"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDebouncedValue = useDebouncedValue;
var _lodash = require("lodash");
var _react = require("react");
var _useUpdateEffect = _interopRequireDefault(require("react-use/lib/useUpdateEffect"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function useDebouncedValue(value, timeout) {
  const [storedValue, setStoredValue] = (0, _react.useState)(value);
  const [isPending, setPending] = (0, _react.useState)(false);
  const setValue = (0, _react.useCallback)(newValue => {
    setStoredValue(newValue);
    setPending(false);
  }, [setStoredValue, setPending]);
  const setDebouncedValue = (0, _react.useMemo)(() => timeout ? (0, _lodash.debounce)(setValue, timeout) : setValue, [setValue, timeout]);
  (0, _react.useEffect)(() => () => {
    var _setDebouncedValue$ca;
    return (_setDebouncedValue$ca = setDebouncedValue.cancel) === null || _setDebouncedValue$ca === void 0 ? void 0 : _setDebouncedValue$ca.call(setDebouncedValue);
  }, [setDebouncedValue]);
  (0, _useUpdateEffect.default)(() => {
    setPending(true);
    setDebouncedValue(value);
    return () => {
      var _setDebouncedValue$ca2;
      return (_setDebouncedValue$ca2 = setDebouncedValue.cancel) === null || _setDebouncedValue$ca2 === void 0 ? void 0 : _setDebouncedValue$ca2.call(setDebouncedValue);
    };
  }, [value]);
  return [storedValue, isPending];
}