"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReferenceLine = void 0;
var _react = _interopRequireDefault(require("react"));
var _reference_line_annotations = require("./reference_line_annotations");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ReferenceLine = ({
  layer,
  axesConfiguration,
  xAxisFormatter,
  paddingMap,
  isHorizontal,
  nextValue,
  yAxesMap
}) => {
  const {
    decorations: [decorationConfig],
    columnToLabel
  } = layer;
  if (!decorationConfig) {
    return null;
  }
  const {
    value
  } = decorationConfig;
  const columnToLabelMap = columnToLabel ? JSON.parse(columnToLabel) : {};
  const axisGroup = (0, _utils.getAxisGroupForReferenceLine)(axesConfiguration, decorationConfig, isHorizontal);
  const formatter = (axisGroup === null || axisGroup === void 0 ? void 0 : axisGroup.formatter) || xAxisFormatter;
  const id = `${layer.layerId}-${value}`;
  const name = decorationConfig.textVisibility ? columnToLabelMap[decorationConfig.forAccessor] : undefined;
  return /*#__PURE__*/_react.default.createElement(_reference_line_annotations.ReferenceLineAnnotations, {
    config: {
      id,
      ...decorationConfig,
      name,
      nextValue,
      axisGroup
    },
    paddingMap: paddingMap,
    axesMap: yAxesMap,
    formatter: formatter,
    isHorizontal: isHorizontal
  });
};
exports.ReferenceLine = ReferenceLine;