"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tagcloudRenderer = exports.strings = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/visualizations-plugin/public");
var _analytics = require("@kbn/analytics");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _common = require("../../common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const strings = {
  getDisplayName: () => _i18n.i18n.translate('expressionTagcloud.renderer.tagcloud.displayName', {
    defaultMessage: 'Tag Cloud visualization'
  }),
  getHelpDescription: () => _i18n.i18n.translate('expressionTagcloud.renderer.tagcloud.helpDescription', {
    defaultMessage: 'Render a tag cloud'
  })
};
exports.strings = strings;
const tagCloudVisClass = {
  height: '100%'
};
const TagCloudChart = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../components/tagcloud_component'))));
const tagcloudRenderer = ({
  getStartDeps
}) => ({
  name: _common.EXPRESSION_NAME,
  displayName: strings.getDisplayName(),
  help: strings.getHelpDescription(),
  reuseDomNode: true,
  render: async (domNode, config, handlers) => {
    const {
      core,
      plugins
    } = getStartDeps();
    handlers.onDestroy(() => {
      (0, _reactDom.unmountComponentAtNode)(domNode);
    });
    const renderComplete = () => {
      const executionContext = handlers.getExecutionContext();
      const containerType = (0, _chartExpressionsCommon.extractContainerType)(executionContext);
      const visualizationType = (0, _chartExpressionsCommon.extractVisualizationType)(executionContext);
      if (containerType && visualizationType) {
        var _plugins$usageCollect;
        (_plugins$usageCollect = plugins.usageCollection) === null || _plugins$usageCollect === void 0 ? void 0 : _plugins$usageCollect.reportUiCounter(containerType, _analytics.METRIC_TYPE.COUNT, [`render_${visualizationType}_${_common.EXPRESSION_NAME}`]);
      }
      handlers.done();
    };
    const palettesRegistry = await plugins.charts.palettes.getPalettes();
    const showNoResult = config.visData.rows.length === 0;
    (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
      theme$: core.theme.theme$
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_react2.ClassNames, null, ({
      css,
      cx
    }) => /*#__PURE__*/_react.default.createElement(_public2.VisualizationContainer, {
      handlers: handlers
      // Class `tagCloudContainer` is generated by `@emotion/react` and passed as a defined class to `VisualizationContainer`.
      // It is used for rendering at `Canvas`.
      ,
      className: cx('tagCloudContainer', css(tagCloudVisClass)),
      renderComplete: renderComplete,
      showNoResult: showNoResult
    }, /*#__PURE__*/_react.default.createElement(TagCloudChart, (0, _extends2.default)({}, config, {
      palettesRegistry: palettesRegistry,
      renderComplete: renderComplete,
      fireEvent: handlers.event,
      syncColors: config.syncColors
    })))))), domNode);
  }
});
exports.tagcloudRenderer = tagcloudRenderer;