"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getShape = void 0;
var _arrow = require("./arrow");
var _arrow_multi = require("./arrow_multi");
var _bookmark = require("./bookmark");
var _cross = require("./cross");
var _circle = require("./circle");
var _hexagon = require("./hexagon");
var _kite = require("./kite");
var _pentagon = require("./pentagon");
var _rhombus = require("./rhombus");
var _semicircle = require("./semicircle");
var _speech_bubble = require("./speech_bubble");
var _square = require("./square");
var _star = require("./star");
var _tag = require("./tag");
var _triangle = require("./triangle");
var _triangle_right = require("./triangle_right");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const shapes = {
  arrow: _arrow.Arrow,
  arrowMulti: _arrow_multi.ArrowMulti,
  bookmark: _bookmark.Bookmark,
  cross: _cross.Cross,
  circle: _circle.Circle,
  hexagon: _hexagon.Hexagon,
  kite: _kite.Kite,
  pentagon: _pentagon.Pentagon,
  rhombus: _rhombus.Rhombus,
  semicircle: _semicircle.Semicircle,
  speechBubble: _speech_bubble.SpeechBubble,
  square: _square.Square,
  star: _star.Star,
  tag: _tag.Tag,
  triangle: _triangle.Triangle,
  triangleRight: _triangle_right.TriangleRight
};
const getShape = shapeType => shapes[shapeType];
exports.getShape = getShape;