"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HorizontalBar = void 0;
var _shape_factory = require("../../reusable/shape_factory");
var _reusable = require("../../reusable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const HorizontalBar = (0, _shape_factory.createShape)({
  viewBox: {
    minX: 0,
    minY: 0,
    width: 208,
    height: 1
  },
  shapeType: _reusable.SvgElementTypes.path,
  shapeProps: {
    d: 'M 0 1 L 200 1'
  },
  textAttributes: {
    x: 208,
    y: 0,
    textAnchor: 'start',
    dominantBaseline: 'central'
  }
});
exports.HorizontalBar = HorizontalBar;