"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RepeatImageComponent = RepeatImageComponent;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

async function loadImage(src) {
  return new Promise((resolve, reject) => {
    const img = new Image();
    img.onload = () => resolve(img);
    img.onerror = error => reject(error);
    img.src = src;
  });
}
async function loadImages(images) {
  const results = await Promise.allSettled([...images.map(loadImage)]);
  return results.map(loadedImage => loadedImage.status === 'rejected' ? null : loadedImage.value);
}
function setImageSize(img, size) {
  if (img.naturalHeight > img.naturalWidth) {
    img.height = size;
  } else {
    img.width = size;
  }
}
function createImageJSX(img) {
  if (!img) {
    return null;
  }
  const params = img.width > img.height ? {
    height: img.height
  } : {
    width: img.width
  };
  return /*#__PURE__*/_react.default.createElement("img", (0, _extends2.default)({
    src: img.src
  }, params, {
    alt: ""
  }));
}
function RepeatImageComponent({
  max,
  count,
  emptyImage: emptyImageSrc,
  image: imageSrc,
  size,
  onLoaded
}) {
  const [images, setImages] = (0, _react.useState)({
    image: null,
    emptyImage: null
  });
  (0, _react.useEffect)(() => {
    loadImages([imageSrc, emptyImageSrc]).then(result => {
      const [image, emptyImage] = result;
      setImages({
        image,
        emptyImage
      });
      onLoaded();
    });
  }, [imageSrc, emptyImageSrc, onLoaded]);
  const imagesToRender = [];
  const {
    image,
    emptyImage
  } = images;
  if (max && count > max) count = max;
  if (image) {
    setImageSize(image, size);
    const imgJSX = createImageJSX(image);
    (0, _lodash.times)(count, () => imagesToRender.push(imgJSX));
  }
  if (emptyImage) {
    setImageSize(emptyImage, size);
    const imgJSX = createImageJSX(emptyImage);
    (0, _lodash.times)(max - count, () => imagesToRender.push(imgJSX));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "repeatImage",
    style: {
      pointerEvents: 'none'
    }
  }, imagesToRender);
}