"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sortPredicateSaveSourceOrder = exports.sortPredicateByType = exports.extractUniqTermsMap = void 0;
var _types = require("../../../common/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const extractUniqTermsMap = (dataTable, columnId) => [...new Set(dataTable.rows.map(item => item[columnId]))].reduce((acc, item, index) => ({
  ...acc,
  [item]: index
}), {});
exports.extractUniqTermsMap = extractUniqTermsMap;
const sortPredicateSaveSourceOrder = () => ([, node1], [, node2]) => {
  var _node1$inputIndex, _node2$inputIndex;
  const [index1] = (_node1$inputIndex = node1.inputIndex) !== null && _node1$inputIndex !== void 0 ? _node1$inputIndex : [];
  const [index2] = (_node2$inputIndex = node2.inputIndex) !== null && _node2$inputIndex !== void 0 ? _node2$inputIndex : [];
  if (index1 !== undefined && index2 !== undefined) {
    return index1 - index2;
  }
  return node2.value - node1.value;
};
exports.sortPredicateSaveSourceOrder = sortPredicateSaveSourceOrder;
const sortPredicatePieDonut = visParams => visParams.respectSourceOrder ? sortPredicateSaveSourceOrder() : undefined;
const sortPredicateMosaic = (visData, columns) => {
  var _columns$;
  const sortingMap = (_columns$ = columns[0]) !== null && _columns$ !== void 0 && _columns$.id ? extractUniqTermsMap(visData, columns[0].id) : {};
  return ([name1, node1], [name2, node2]) => {
    // Sorting for first group
    if (columns.length === 1 || node1.children.length && name1 in sortingMap && node2.children.length && name2 in sortingMap) {
      return sortingMap[name1] - sortingMap[name2];
    }

    // Sorting for second group
    return node2.value - node1.value;
  };
};
const sortPredicateWaffle = () => ([, node1], [, node2]) => node2.value - node1.value;
const sortPredicateByType = (chartType, visParams, visData, columns) => ({
  [_types.ChartTypes.PIE]: () => sortPredicatePieDonut(visParams),
  [_types.ChartTypes.DONUT]: () => sortPredicatePieDonut(visParams),
  [_types.ChartTypes.WAFFLE]: () => sortPredicateWaffle(),
  [_types.ChartTypes.TREEMAP]: () => undefined,
  [_types.ChartTypes.MOSAIC]: () => sortPredicateMosaic(visData, columns)
})[chartType]();
exports.sortPredicateByType = sortPredicateByType;