"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLayers = void 0;
var _ = require("..");
var _types = require("../../../common/types");
var _sort_predicate = require("./sort_predicate");
var _get_color = require("./get_color");
var _get_node_labels = require("./get_node_labels");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const EMPTY_SLICE = Symbol('empty_slice');
const getLayers = (chartType, columns, visParams, visData, overwriteColors = {}, rows, palettes, formatters, formatter, syncColors, isDarkMode) => {
  var _columns$;
  const fillLabel = {
    valueFont: {
      fontWeight: 700
    }
  };
  if (!visParams.labels.values) {
    fillLabel.valueFormatter = () => '';
  }
  const isSplitChart = Boolean(visParams.dimensions.splitColumn || visParams.dimensions.splitRow);
  let byDataPalette;
  if (!syncColors && (_columns$ = columns[1]) !== null && _columns$ !== void 0 && _columns$.id && palettes && visParams.palette) {
    byDataPalette = (0, _get_color.byDataColorPaletteMap)(rows, columns[1].id, palettes === null || palettes === void 0 ? void 0 : palettes.get(visParams.palette.name), visParams.palette);
  }
  const sortPredicateForType = (0, _sort_predicate.sortPredicateByType)(chartType, visParams, visData, columns);
  const distinctSeries = (0, _.getDistinctSeries)(rows, columns);
  return columns.map((col, layerIndex) => {
    var _col$meta, _col$meta$sourceParam;
    return {
      groupByRollup: d => {
        var _d$col$id;
        return col.id ? (_d$col$id = d[col.id]) !== null && _d$col$id !== void 0 ? _d$col$id : EMPTY_SLICE : col.name;
      },
      showAccessor: d => d !== EMPTY_SLICE,
      nodeLabel: d => (0, _get_node_labels.getNodeLabel)(d, col, formatters, formatter.deserialize),
      fillLabel: layerIndex === 0 && chartType === _types.ChartTypes.MOSAIC ? {
        ...fillLabel,
        minFontSize: 14,
        maxFontSize: 14,
        clipText: true
      } : fillLabel,
      sortPredicate: (_col$meta = col.meta) !== null && _col$meta !== void 0 && (_col$meta$sourceParam = _col$meta.sourceParams) !== null && _col$meta$sourceParam !== void 0 && _col$meta$sourceParam.consolidatedMetricsColumn ? (0, _sort_predicate.sortPredicateSaveSourceOrder)() : sortPredicateForType,
      shape: {
        fillColor: (key, sortIndex, node) => (0, _get_color.getColor)(chartType, key, node, layerIndex, isSplitChart, overwriteColors, distinctSeries, {
          columnsLength: columns.length,
          rowsLength: rows.length
        }, visParams, palettes, byDataPalette, syncColors, isDarkMode, formatter, col, formatters)
      }
    };
  });
};
exports.getLayers = getLayers;