"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.metricRendererFactory = exports.getMetricRenderer = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/presentation-util-plugin/common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const strings = {
  getDisplayName: () => _i18n.i18n.translate('expressionMetric.renderer.metric.displayName', {
    defaultMessage: 'Metric'
  }),
  getHelpDescription: () => _i18n.i18n.translate('expressionMetric.renderer.metric.helpDescription', {
    defaultMessage: 'Render a number over a label'
  })
};
const getMetricRenderer = (theme$ = _common.defaultTheme$) => () => ({
  name: 'metric',
  displayName: strings.getDisplayName(),
  help: strings.getHelpDescription(),
  reuseDomNode: true,
  render: async (domNode, config, handlers) => {
    const {
      MetricComponent
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../components/metric_component')));
    handlers.onDestroy(() => {
      (0, _reactDom.unmountComponentAtNode)(domNode);
    });
    (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
      theme$: theme$
    }, /*#__PURE__*/_react.default.createElement(MetricComponent, {
      label: config.label,
      labelFont: config.labelFont ? config.labelFont.spec : {},
      metric: config.metric,
      metricFont: config.metricFont ? config.metricFont.spec : {},
      metricFormat: config.metricFormat
    }))), domNode, () => handlers.done());
  }
});
exports.getMetricRenderer = getMetricRenderer;
const metricRendererFactory = core => getMetricRenderer(core.theme.theme$);
exports.metricRendererFactory = metricRendererFactory;