"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldApplyColor = exports.parseRgbString = exports.needsLightText = void 0;
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const parseRgbString = rgb => {
  var _rgb$match;
  const groups = (_rgb$match = rgb.match(/rgb\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*?(,\s*(\d+)\s*)?\)/)) !== null && _rgb$match !== void 0 ? _rgb$match : [];
  if (!groups) {
    return null;
  }
  const red = parseFloat(groups[1]);
  const green = parseFloat(groups[2]);
  const blue = parseFloat(groups[3]);
  const opacity = groups[5] ? parseFloat(groups[5]) : undefined;
  return {
    red,
    green,
    blue,
    opacity
  };
};
exports.parseRgbString = parseRgbString;
const shouldApplyColor = color => {
  const rgb = parseRgbString(color);
  const {
    opacity
  } = rgb !== null && rgb !== void 0 ? rgb : {};

  // if opacity === 0, it means there is no color to apply to the metric
  return !rgb || rgb && opacity !== 0;
};
exports.shouldApplyColor = shouldApplyColor;
const needsLightText = (bgColor = '') => {
  const rgb = parseRgbString(bgColor);
  if (!rgb) {
    return false;
  }
  const {
    red,
    green,
    blue,
    opacity
  } = rgb;
  return (0, _eui.isColorDark)(red, green, blue) && opacity !== 0;
};
exports.needsLightText = needsLightText;