"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.HeatmapComponent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/charts-plugin/public");
var _utils = require("@kbn/visualizations-plugin/common/utils");
var _constants = require("@kbn/visualizations-plugin/common/constants");
var _chartIcons = require("@kbn/chart-icons");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _helpers = require("./helpers");
var _get_color_picker = require("../utils/get_color_picker");
var _constants2 = require("../constants");
var _chart_split = require("./chart_split");
var _get_split_dimension_utils = require("../utils/get_split_dimension_utils");
require("./index.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getStops({
  colors,
  stops,
  range
}, {
  min,
  max
}) {
  if (stops.length) {
    return stops.slice(0, stops.length - 1);
  }
  // Do not use relative values here
  const maxValue = range === 'percent' ? 100 : max;
  const minValue = range === 'percent' ? 0 : min;
  const step = (maxValue - minValue) / colors.length;
  return colors.slice(0, colors.length - 1).map((_, i) => minValue + (i + 1) * step);
}

/**
 * Heatmaps use a different convention than palettes (same convention as EuiColorStops)
 * so stops need to be left shifted.
 * Values normalization provides a percent => absolute array of values
 */
function shiftAndNormalizeStops(params, {
  min,
  max
}) {
  // data min is the fallback in case of default options
  const absMin = params.range === 'percent' ? 0 : min;
  return [params.stops.length ? params.rangeMin : absMin, ...getStops(params, {
    min,
    max
  })].map(value => {
    let result = value;
    if (params.range === 'percent') {
      result = min + (max - min) * value / 100;
    }
    // for a range of 1 value the formulas above will divide by 0, so here's a safety guard
    if (Number.isNaN(result)) {
      return 1;
    }
    return Number(result.toFixed(2));
  });
}
function computeColorRanges(paletteService, paletteParams, baseColor, minMax) {
  const paletteColors = (paletteParams === null || paletteParams === void 0 ? void 0 : paletteParams.colors) || (0, _helpers.applyPaletteParams)(paletteService, {
    type: 'palette',
    name: _constants2.defaultPaletteParams.name
  }, minMax).map(({
    color
  }) => color);
  // Repeat the first color at the beginning to cover below and above the defined palette
  const colors = [paletteColors[0], ...paletteColors];
  const ranges = shiftAndNormalizeStops({
    gradient: false,
    range: _constants2.defaultPaletteParams.rangeType,
    rangeMin: _constants2.defaultPaletteParams.rangeMin,
    rangeMax: _constants2.defaultPaletteParams.rangeMax,
    stops: [],
    ...paletteParams,
    colors: colors.slice(1)
  }, minMax);
  return {
    colors,
    ranges
  };
}
const HeatmapComponent = /*#__PURE__*/(0, _react.memo)(({
  data,
  args,
  timeZone,
  formatFactory,
  chartsThemeService,
  chartsActiveCursorService,
  datatableUtilities,
  onClickValue,
  onSelectRange,
  paletteService,
  uiState,
  interactive,
  syncTooltips,
  syncCursor,
  renderComplete,
  overrides
}) => {
  var _args$palette, _uiState$get, _args$legend$maxLines, _args$legend, _ref, _args$gridConfig$stro, _chartTheme$axes, _chartTheme$axes$grid, _chartTheme$axes$grid2, _ref2, _args$gridConfig$stro2, _chartTheme$axes2, _chartTheme$axes2$gri, _chartTheme$axes2$gri2, _args$gridConfig$isCe, _chartTheme$axes$tick, _chartTheme$axes3, _chartTheme$axes3$tic, _chartTheme$axes$tick2, _chartTheme$axes4, _chartTheme$axes4$tic, _args$gridConfig$xTit, _args$gridConfig$yTit, _args$legend$legendSi, _window$_echDebugStat;
  const chartRef = (0, _react.useRef)(null);
  const chartTheme = chartsThemeService.useChartsTheme();
  const isDarkTheme = chartsThemeService.useDarkMode();
  // legacy heatmap legend is handled by the uiState
  const [showLegend, setShowLegend] = (0, _react.useState)(() => {
    var _args$legend$isVisibl;
    const bwcLegendStateDefault = (_args$legend$isVisibl = args.legend.isVisible) !== null && _args$legend$isVisibl !== void 0 ? _args$legend$isVisibl : true;
    return uiState === null || uiState === void 0 ? void 0 : uiState.get('vis.legendOpen', bwcLegendStateDefault);
  });
  const chartBaseTheme = chartsThemeService.useChartsBaseTheme();
  const toggleLegend = (0, _react.useCallback)(() => {
    if (!interactive) {
      return;
    }
    setShowLegend(value => {
      var _uiState$set;
      const newValue = !value;
      uiState === null || uiState === void 0 ? void 0 : (_uiState$set = uiState.set) === null || _uiState$set === void 0 ? void 0 : _uiState$set.call(uiState, 'vis.legendOpen', newValue);
      return newValue;
    });
  }, [uiState, interactive]);
  const setColor = (0, _react.useCallback)((newColor, seriesLabel) => {
    const colors = (uiState === null || uiState === void 0 ? void 0 : uiState.get('vis.colors')) || {};
    if (colors[seriesLabel] === newColor || !newColor) {
      delete colors[seriesLabel];
    } else {
      colors[seriesLabel] = newColor;
    }
    uiState === null || uiState === void 0 ? void 0 : uiState.setSilent('vis.colors', null);
    uiState === null || uiState === void 0 ? void 0 : uiState.set('vis.colors', colors);
    uiState === null || uiState === void 0 ? void 0 : uiState.emit('reload');
    uiState === null || uiState === void 0 ? void 0 : uiState.emit('colorChanged');
  }, [uiState]);
  const onRenderChange = (0, _react.useCallback)((isRendered = true) => {
    if (isRendered) {
      renderComplete();
    }
  }, [renderComplete]);
  const table = data;
  const valueAccessor = args.valueAccessor ? (0, _utils.getAccessorByDimension)(args.valueAccessor, table.columns) : undefined;
  const minMaxByColumnId = (0, _react.useMemo)(() => (0, _helpers.findMinMaxByColumnId)([valueAccessor], table), [valueAccessor, table]);
  const paletteParams = (_args$palette = args.palette) === null || _args$palette === void 0 ? void 0 : _args$palette.params;
  const xAccessor = args.xAccessor ? (0, _utils.getAccessorByDimension)(args.xAccessor, table.columns) : undefined;
  const yAccessor = args.yAccessor ? (0, _utils.getAccessorByDimension)(args.yAccessor, table.columns) : undefined;
  const splitChartRowAccessor = args.splitRowAccessor ? (0, _get_split_dimension_utils.getSplitDimensionAccessor)(data.columns, args.splitRowAccessor, formatFactory) : undefined;
  const splitChartColumnAccessor = args.splitColumnAccessor ? (0, _get_split_dimension_utils.getSplitDimensionAccessor)(data.columns, args.splitColumnAccessor, formatFactory) : undefined;
  const xAxisColumnIndex = table.columns.findIndex(v => v.id === xAccessor);
  const yAxisColumnIndex = table.columns.findIndex(v => v.id === yAccessor);
  const xAxisColumn = table.columns[xAxisColumnIndex];
  const yAxisColumn = table.columns[yAxisColumnIndex];
  const valueColumn = table.columns.find(v => v.id === valueAccessor);
  const xAxisMeta = xAxisColumn === null || xAxisColumn === void 0 ? void 0 : xAxisColumn.meta;
  const isTimeBasedSwimLane = (xAxisMeta === null || xAxisMeta === void 0 ? void 0 : xAxisMeta.type) === 'date';
  const xValuesFormatter = (0, _react.useMemo)(() => formatFactory(xAxisMeta === null || xAxisMeta === void 0 ? void 0 : xAxisMeta.params), [formatFactory, xAxisMeta === null || xAxisMeta === void 0 ? void 0 : xAxisMeta.params]);
  const yValuesFormatter = (0, _react.useMemo)(() => formatFactory(yAxisColumn === null || yAxisColumn === void 0 ? void 0 : yAxisColumn.meta.params), [formatFactory, yAxisColumn === null || yAxisColumn === void 0 ? void 0 : yAxisColumn.meta.params]);
  const metricFormatter = (0, _react.useMemo)(() => formatFactory((0, _utils.getFormatByAccessor)(args.valueAccessor, table.columns)), [args.valueAccessor, formatFactory, table.columns]);
  const formattedTable = (0, _helpers.getFormattedTable)(table, formatFactory);
  let chartData = formattedTable.table.rows.filter(v => v[valueAccessor] === null || typeof v[valueAccessor] === 'number');
  const handleCursorUpdate = (0, _public2.useActiveCursor)(chartsActiveCursorService, chartRef, {
    datatables: [formattedTable.table]
  });
  const onElementClick = (0, _react.useCallback)(e => {
    const cell = e[0][0];
    const {
      x,
      y,
      smVerticalAccessorValue,
      smHorizontalAccessorValue
    } = cell.datum;
    const points = [{
      row: table.rows.findIndex(r => {
        if (!xAxisColumn) return false;
        if (formattedTable.formattedColumns[xAxisColumn.id]) {
          // stringify the value to compare with the chart value
          return xValuesFormatter.convert(r[xAxisColumn.id]) === x;
        }
        return r[xAxisColumn.id] === x;
      }),
      column: xAxisColumnIndex,
      value: x
    }, ...(yAxisColumn ? [{
      row: table.rows.findIndex(r => {
        if (formattedTable.formattedColumns[yAxisColumn.id]) {
          // stringify the value to compare with the chart value
          return yValuesFormatter.convert(r[yAxisColumn.id]) === y;
        }
        return r[yAxisColumn.id] === y;
      }),
      column: yAxisColumnIndex,
      value: y
    }] : [])];
    if (smHorizontalAccessorValue && args.splitColumnAccessor) {
      const point = (0, _get_split_dimension_utils.createSplitPoint)(args.splitColumnAccessor, smHorizontalAccessorValue, formatFactory, table);
      if (point) {
        points.push(point);
      }
    }
    if (smVerticalAccessorValue && args.splitRowAccessor) {
      const point = (0, _get_split_dimension_utils.createSplitPoint)(args.splitRowAccessor, smVerticalAccessorValue, formatFactory, table);
      if (point) {
        points.push(point);
      }
    }
    const context = {
      data: points.map(point => ({
        row: point.row,
        column: point.column,
        value: point.value,
        table
      }))
    };
    onClickValue(context);
  }, [args.splitColumnAccessor, args.splitRowAccessor, formatFactory, formattedTable.formattedColumns, onClickValue, table, xAxisColumn, xAxisColumnIndex, xValuesFormatter, yAxisColumn, yAxisColumnIndex, yValuesFormatter]);
  const onBrushEnd = (0, _react.useCallback)(e => {
    const {
      x,
      y
    } = e;
    if (isTimeBasedSwimLane) {
      const context = {
        range: x,
        table,
        column: xAxisColumnIndex
      };
      onSelectRange(context);
    } else {
      const points = [];
      if (yAxisColumn) {
        y.forEach(v => {
          points.push({
            row: table.rows.findIndex(r => {
              if (formattedTable.formattedColumns[yAxisColumn.id]) {
                // stringify the value to compare with the chart value
                return yValuesFormatter.convert(r[yAxisColumn.id]) === v;
              }
              return r[yAxisColumn.id] === v;
            }),
            column: yAxisColumnIndex,
            value: v
          });
        });
      }
      if (xAxisColumn) {
        x.forEach(v => {
          points.push({
            row: table.rows.findIndex(r => {
              if (formattedTable.formattedColumns[xAxisColumn.id]) {
                // stringify the value to compare with the chart value
                return xValuesFormatter.convert(r[xAxisColumn.id]) === v;
              }
              return r[xAxisColumn.id] === v;
            }),
            column: xAxisColumnIndex,
            value: v
          });
        });
      }
      const context = {
        data: points.map(point => ({
          row: point.row,
          column: point.column,
          value: point.value,
          table
        }))
      };
      onClickValue(context);
    }
  }, [formattedTable.formattedColumns, isTimeBasedSwimLane, onClickValue, onSelectRange, table, xAxisColumn, xAxisColumnIndex, xValuesFormatter, yAxisColumn, yAxisColumnIndex, yValuesFormatter]);
  if (!chartData || !chartData.length) {
    return /*#__PURE__*/_react.default.createElement(_public2.EmptyPlaceholder, {
      icon: _chartIcons.IconChartHeatmap,
      renderComplete: onRenderChange
    });
  }
  if (!yAxisColumn) {
    // required for tooltip
    chartData = chartData.map(row => {
      return {
        ...row,
        unifiedY: ''
      };
    });
  }
  if (!xAxisColumn) {
    // required for tooltip
    chartData = chartData.map(row => {
      return {
        ...row,
        unifiedX: ''
      };
    });
  }
  const {
    min,
    max
  } = minMaxByColumnId[valueAccessor];
  // formatters
  const dateHistogramMeta = xAxisColumn ? datatableUtilities.getDateHistogramMeta(xAxisColumn) : undefined;
  if (!valueColumn) {
    // Chart is not ready
    return null;
  }

  // Fallback to the ordinal scale type when a single row of data is provided.
  // Related issue https://github.com/elastic/elastic-charts/issues/1184
  let xScale = {
    type: _charts.ScaleType.Ordinal
  };
  if (isTimeBasedSwimLane && chartData.length > 1) {
    const dateInterval = dateHistogramMeta === null || dateHistogramMeta === void 0 ? void 0 : dateHistogramMeta.interval;
    const esInterval = dateInterval ? _public.search.aggs.parseEsInterval(dateInterval) : undefined;
    if (esInterval) {
      xScale = {
        type: _charts.ScaleType.Time,
        interval: esInterval.type === 'fixed' ? {
          type: 'fixed',
          unit: esInterval.unit,
          value: esInterval.value
        } : {
          type: 'calendar',
          unit: esInterval.unit,
          value: esInterval.value
        }
      };
    }
  }
  const tooltip = {
    type: args.showTooltip ? _charts.TooltipType.Follow : _charts.TooltipType.None
  };
  const valueFormatter = d => {
    var _metricFormatter$conv;
    let value = d;
    if (args.percentageMode) {
      const percentageNumber = Math.abs(value - min) / (max - min) * 100;
      value = parseInt(percentageNumber.toString(), 10) / 100;
    }
    return `${(_metricFormatter$conv = metricFormatter.convert(value)) !== null && _metricFormatter$conv !== void 0 ? _metricFormatter$conv : ''}`;
  };
  const {
    colors,
    ranges
  } = computeColorRanges(paletteService, paletteParams, isDarkTheme ? '#000' : '#fff', minMaxByColumnId[valueAccessor]);

  // adds a very small number to the max value to make sure the max value will be included
  const smattering = 0.00001;
  let endValueDistinctBounds = max + smattering;
  if (paletteParams !== null && paletteParams !== void 0 && paletteParams.rangeMax || (paletteParams === null || paletteParams === void 0 ? void 0 : paletteParams.rangeMax) === 0) {
    endValueDistinctBounds = ((paletteParams === null || paletteParams === void 0 ? void 0 : paletteParams.range) === 'number' ? paletteParams.rangeMax : min + (max - min) * paletteParams.rangeMax / 100) + smattering;
  }
  const overwriteColors = (_uiState$get = uiState === null || uiState === void 0 ? void 0 : uiState.get('vis.colors')) !== null && _uiState$get !== void 0 ? _uiState$get : null;
  const hasSingleValue = max === min;
  const bands = ranges.map((start, index, array) => {
    const isPenultimate = index === array.length - 1;
    const nextValue = array[index + 1];
    // by default the last range is right-open
    let endValue = isPenultimate ? Number.POSITIVE_INFINITY : nextValue;
    const startValue = isPenultimate && hasSingleValue ? min : start;
    // if the lastRangeIsRightOpen is set to false, we need to set the last range to the max value
    if (args.lastRangeIsRightOpen === false) {
      const lastBand = hasSingleValue ? Number.POSITIVE_INFINITY : endValueDistinctBounds;
      endValue = isPenultimate ? lastBand : nextValue;
    }
    let overwriteArrayIdx;
    if (endValue === Number.POSITIVE_INFINITY) {
      overwriteArrayIdx = `≥ ${metricFormatter.convert(startValue)}`;
    } else {
      overwriteArrayIdx = `${metricFormatter.convert(start)} - ${metricFormatter.convert(endValue)}`;
    }
    const overwriteColor = overwriteColors === null || overwriteColors === void 0 ? void 0 : overwriteColors[overwriteArrayIdx];
    return {
      // with the default continuity:above the every range is left-closed
      start: startValue,
      end: endValue,
      // the current colors array contains a duplicated color at the beginning that we need to skip
      color: overwriteColor !== null && overwriteColor !== void 0 ? overwriteColor : colors[index + 1]
    };
  });
  const {
    theme: settingsThemeOverrides = {},
    ...settingsOverrides
  } = (0, _chartExpressionsCommon.getOverridesFor)(overrides, 'settings');
  const themeOverrides = {
    legend: {
      labelOptions: {
        maxLines: args.legend.shouldTruncate ? (_args$legend$maxLines = (_args$legend = args.legend) === null || _args$legend === void 0 ? void 0 : _args$legend.maxLines) !== null && _args$legend$maxLines !== void 0 ? _args$legend$maxLines : 1 : 0
      }
    },
    heatmap: {
      grid: {
        stroke: {
          width: (_ref = (_args$gridConfig$stro = args.gridConfig.strokeWidth) !== null && _args$gridConfig$stro !== void 0 ? _args$gridConfig$stro : (_chartTheme$axes = chartTheme.axes) === null || _chartTheme$axes === void 0 ? void 0 : (_chartTheme$axes$grid = _chartTheme$axes.gridLine) === null || _chartTheme$axes$grid === void 0 ? void 0 : (_chartTheme$axes$grid2 = _chartTheme$axes$grid.horizontal) === null || _chartTheme$axes$grid2 === void 0 ? void 0 : _chartTheme$axes$grid2.strokeWidth) !== null && _ref !== void 0 ? _ref : 1,
          color: (_ref2 = (_args$gridConfig$stro2 = args.gridConfig.strokeColor) !== null && _args$gridConfig$stro2 !== void 0 ? _args$gridConfig$stro2 : (_chartTheme$axes2 = chartTheme.axes) === null || _chartTheme$axes2 === void 0 ? void 0 : (_chartTheme$axes2$gri = _chartTheme$axes2.gridLine) === null || _chartTheme$axes2$gri === void 0 ? void 0 : (_chartTheme$axes2$gri2 = _chartTheme$axes2$gri.horizontal) === null || _chartTheme$axes2$gri2 === void 0 ? void 0 : _chartTheme$axes2$gri2.stroke) !== null && _ref2 !== void 0 ? _ref2 : '#D3DAE6'
        }
      },
      cell: {
        maxWidth: 'fill',
        maxHeight: 'fill',
        label: {
          visible: (_args$gridConfig$isCe = args.gridConfig.isCellLabelVisible) !== null && _args$gridConfig$isCe !== void 0 ? _args$gridConfig$isCe : false,
          minFontSize: 8,
          maxFontSize: 18,
          useGlobalMinFontSize: true // override the min if there's a different directive upstream
        },

        border: {
          strokeWidth: 0
        }
      },
      yAxisLabel: {
        visible: !!yAxisColumn && args.gridConfig.isYAxisLabelVisible,
        // eui color subdued
        textColor: (_chartTheme$axes$tick = (_chartTheme$axes3 = chartTheme.axes) === null || _chartTheme$axes3 === void 0 ? void 0 : (_chartTheme$axes3$tic = _chartTheme$axes3.tickLabel) === null || _chartTheme$axes3$tic === void 0 ? void 0 : _chartTheme$axes3$tic.fill) !== null && _chartTheme$axes$tick !== void 0 ? _chartTheme$axes$tick : '#6a717d',
        padding: yAxisColumn !== null && yAxisColumn !== void 0 && yAxisColumn.name ? 8 : 0
      },
      xAxisLabel: {
        visible: Boolean(args.gridConfig.isXAxisLabelVisible && xAxisColumn),
        // eui color subdued
        textColor: (_chartTheme$axes$tick2 = (_chartTheme$axes4 = chartTheme.axes) === null || _chartTheme$axes4 === void 0 ? void 0 : (_chartTheme$axes4$tic = _chartTheme$axes4.tickLabel) === null || _chartTheme$axes4$tic === void 0 ? void 0 : _chartTheme$axes4$tic.fill) !== null && _chartTheme$axes$tick2 !== void 0 ? _chartTheme$axes$tick2 : `#6a717d`,
        padding: xAxisColumn !== null && xAxisColumn !== void 0 && xAxisColumn.name ? 8 : 0
      },
      brushMask: {
        fill: isDarkTheme ? 'rgb(30,31,35,80%)' : 'rgb(247,247,247,50%)'
      },
      brushArea: {
        stroke: isDarkTheme ? 'rgb(255, 255, 255)' : 'rgb(105, 112, 125)'
      }
    }
  };
  const xAxisTitle = (_args$gridConfig$xTit = args.gridConfig.xTitle) !== null && _args$gridConfig$xTit !== void 0 ? _args$gridConfig$xTit : xAxisColumn === null || xAxisColumn === void 0 ? void 0 : xAxisColumn.name;
  const yAxisTitle = (_args$gridConfig$yTit = args.gridConfig.yTitle) !== null && _args$gridConfig$yTit !== void 0 ? _args$gridConfig$yTit : yAxisColumn === null || yAxisColumn === void 0 ? void 0 : yAxisColumn.name;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showLegend !== undefined && /*#__PURE__*/_react.default.createElement(_public2.LegendToggle, {
    onClick: toggleLegend,
    showLegend: showLegend,
    legendPosition: args.legend.position
  }), /*#__PURE__*/_react.default.createElement(_get_color_picker.LegendColorPickerWrapperContext.Provider, {
    value: {
      uiState,
      setColor,
      legendPosition: args.legend.position
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    ref: chartRef
  }, /*#__PURE__*/_react.default.createElement(_chart_split.ChartSplit, {
    splitColumnAccessor: splitChartColumnAccessor,
    splitRowAccessor: splitChartRowAccessor
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, (0, _extends2.default)({
    onRenderChange: onRenderChange,
    noResults: /*#__PURE__*/_react.default.createElement(_public2.EmptyPlaceholder, {
      icon: _chartIcons.IconChartHeatmap,
      renderComplete: onRenderChange
    }),
    onPointerUpdate: syncCursor ? handleCursorUpdate : undefined,
    externalPointerEvents: {
      tooltip: {
        visible: syncTooltips
      }
    },
    onElementClick: interactive ? onElementClick : undefined,
    showLegend: showLegend !== null && showLegend !== void 0 ? showLegend : args.legend.isVisible,
    legendPosition: args.legend.position,
    legendSize: _constants.LegendSizeToPixels[(_args$legend$legendSi = args.legend.legendSize) !== null && _args$legend$legendSi !== void 0 ? _args$legend$legendSi : _constants.DEFAULT_LEGEND_SIZE],
    legendColorPicker: uiState ? _get_color_picker.LegendColorPickerWrapper : undefined,
    debugState: (_window$_echDebugStat = window._echDebugStateFlag) !== null && _window$_echDebugStat !== void 0 ? _window$_echDebugStat : false,
    tooltip: tooltip,
    theme: [themeOverrides, chartTheme, ...(Array.isArray(settingsThemeOverrides) ? settingsThemeOverrides : [settingsThemeOverrides])],
    baseTheme: chartBaseTheme,
    xDomain: {
      min: dateHistogramMeta && dateHistogramMeta.timeRange ? new Date(dateHistogramMeta.timeRange.from).getTime() : NaN,
      max: dateHistogramMeta && dateHistogramMeta.timeRange ? new Date(dateHistogramMeta.timeRange.to).getTime() : NaN
    },
    onBrushEnd: interactive ? onBrushEnd : undefined,
    ariaLabel: args.ariaLabel,
    ariaUseDefaultSummary: !args.ariaLabel
  }, settingsOverrides)), /*#__PURE__*/_react.default.createElement(_charts.Heatmap, {
    id: "heatmap",
    name: valueColumn.name,
    colorScale: {
      type: 'bands',
      bands
    },
    timeZone: timeZone,
    data: chartData,
    xAccessor: xAccessor || 'unifiedX',
    yAccessor: yAccessor || 'unifiedY',
    valueAccessor: valueAccessor,
    valueFormatter: valueFormatter,
    xScale: xScale,
    ySortPredicate: yAxisColumn ? (0, _helpers.getSortPredicate)(yAxisColumn) : 'dataIndex',
    xSortPredicate: xAxisColumn ? (0, _helpers.getSortPredicate)(xAxisColumn) : 'dataIndex',
    xAxisLabelName: (xAxisColumn === null || xAxisColumn === void 0 ? void 0 : xAxisColumn.name) || '',
    yAxisLabelName: (yAxisColumn === null || yAxisColumn === void 0 ? void 0 : yAxisColumn.name) || '',
    xAxisTitle: args.gridConfig.isXAxisTitleVisible ? xAxisTitle : undefined,
    yAxisTitle: args.gridConfig.isYAxisTitleVisible ? yAxisTitle : undefined,
    xAxisLabelFormatter: v => args.gridConfig.isXAxisLabelVisible ? `${xAccessor && formattedTable.formattedColumns[xAccessor] ? v : xValuesFormatter.convert(v)}` : '',
    yAxisLabelFormatter: yAxisColumn ? v => {
      var _yValuesFormatter$con;
      return args.gridConfig.isYAxisLabelVisible ? `${yAccessor && formattedTable.formattedColumns[yAccessor] ? v : (_yValuesFormatter$con = yValuesFormatter.convert(v)) !== null && _yValuesFormatter$con !== void 0 ? _yValuesFormatter$con : ''}` : '';
    } : undefined
  }))));
});

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
exports.default = exports.HeatmapComponent = HeatmapComponent;