"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpressionGaugePlugin = void 0;
var _public = require("@kbn/kibana-utils-plugin/public");
var _common = require("../common");
var _services = require("./services");
var _expression_renderers = require("./expression_renderers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal */
class ExpressionGaugePlugin {
  setup(core, {
    expressions,
    charts
  }) {
    charts.palettes.getPalettes().then(palettes => {
      (0, _services.setPaletteService)(palettes);
    });
    const getStartDeps = (0, _public.createStartServicesGetter)(core.getStartServices);
    expressions.registerFunction(_common.gaugeFunction);
    expressions.registerRenderer((0, _expression_renderers.gaugeRenderer)({
      getStartDeps
    }));
  }
  start(core, {
    fieldFormats
  }) {
    (0, _services.setFormatService)(fieldFormats);
  }
}
exports.ExpressionGaugePlugin = ExpressionGaugePlugin;