"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.plugin = exports.config = void 0;
var _configSchema = require("@kbn/config-schema");
var _plugin = require("./plugin");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const configSchema = _configSchema.schema.object({
  annotations: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: true
    }),
    index: _configSchema.schema.string({
      defaultValue: 'observability-annotations'
    })
  })
});
const config = {
  exposeToBrowser: {
    unsafe: true
  },
  schema: configSchema
};
exports.config = config;
const plugin = initContext => new _plugin.ExploratoryViewPlugin(initContext);
exports.plugin = plugin;