"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.dataViewList = exports.ObservabilityDataViews = void 0;
exports.getDataTypeIndices = getDataTypeIndices;
exports.isParamsSame = isParamsSame;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/kibana-utils-plugin/public");
var _common = require("@kbn/data-views-plugin/common");
var _labels = require("../../components/shared/exploratory_view/labels");
var _runtime_fields = require("../../components/shared/exploratory_view/configurations/synthetics/runtime_fields");
var _utils = require("../../components/shared/exploratory_view/utils/utils");
var _field_formats = require("../../components/shared/exploratory_view/configurations/rum/field_formats");
var _field_formats2 = require("../../components/shared/exploratory_view/configurations/synthetics/field_formats");
var _field_formats3 = require("../../components/shared/exploratory_view/configurations/apm/field_formats");
var _data_handler = require("../../data_handler");
var _field_formats4 = require("../../components/shared/exploratory_view/configurations/infra_metrics/field_formats");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const appFieldFormats = {
  infra_logs: null,
  infra_metrics: _field_formats4.infraMetricsFieldFormats,
  ux: _field_formats.rumFieldFormats,
  apm: _field_formats3.apmFieldFormats,
  uptime: _field_formats2.syntheticsFieldFormats,
  synthetics: _field_formats2.syntheticsFieldFormats,
  mobile: _field_formats3.apmFieldFormats,
  alerts: null
};
const appRuntimeFields = {
  infra_logs: null,
  infra_metrics: null,
  ux: null,
  apm: null,
  uptime: _runtime_fields.syntheticsRuntimeFields,
  synthetics: _runtime_fields.syntheticsRuntimeFields,
  mobile: null,
  alerts: null
};
function getFieldFormatsForApp(app) {
  return {
    runtimeFields: appRuntimeFields[app],
    formats: appFieldFormats[app]
  };
}
const dataViewList = {
  synthetics: 'synthetics_static_index_pattern_id',
  uptime: 'uptime_static_index_pattern_id',
  apm: 'apm_static_index_pattern_id',
  ux: 'rum_static_index_pattern_id',
  infra_logs: 'infra_logs_static_index_pattern_id',
  infra_metrics: 'infra_metrics_static_index_pattern_id',
  mobile: 'mobile_static_index_pattern_id',
  alerts: 'alerts_static_index_pattern_id'
};
exports.dataViewList = dataViewList;
const getAppIndicesWithPattern = (app, indices) => {
  return `${indices}`;
};
const getAppDataViewId = (app, indices) => {
  var _dataViewList$app;
  // Replace characters / ? , " < > | * with _
  const postfix = indices.replace(/[^A-Z0-9]+/gi, '_').toLowerCase();
  return `${(_dataViewList$app = dataViewList === null || dataViewList === void 0 ? void 0 : dataViewList[app]) !== null && _dataViewList$app !== void 0 ? _dataViewList$app : app}_${postfix}`;
};
async function getDataTypeIndices(dataType) {
  var _getDataHandler, _getDataHandler2;
  switch (dataType) {
    case 'synthetics':
      return {
        hasData: true,
        indices: 'synthetics-*'
      };
    case 'mobile':
    case 'ux':
    case 'apm':
      const resultApm = await ((_getDataHandler = (0, _data_handler.getDataHandler)('apm')) === null || _getDataHandler === void 0 ? void 0 : _getDataHandler.hasData());
      return {
        hasData: Boolean(resultApm === null || resultApm === void 0 ? void 0 : resultApm.hasData),
        indices: (0, _utils.getApmDataViewTitle)(resultApm === null || resultApm === void 0 ? void 0 : resultApm.indices)
      };
    case 'alerts':
      return {
        hasData: true,
        indices: '.alerts-observability*'
      };
    default:
      const resultUx = await ((_getDataHandler2 = (0, _data_handler.getDataHandler)(dataType)) === null || _getDataHandler2 === void 0 ? void 0 : _getDataHandler2.hasData());
      return {
        hasData: Boolean(resultUx === null || resultUx === void 0 ? void 0 : resultUx.hasData),
        indices: resultUx === null || resultUx === void 0 ? void 0 : resultUx.indices
      };
  }
}
function isParamsSame(param1, param2) {
  const isSame = (param1 === null || param1 === void 0 ? void 0 : param1.inputFormat) === (param2 === null || param2 === void 0 ? void 0 : param2.inputFormat) && (param1 === null || param1 === void 0 ? void 0 : param1.outputFormat) === (param2 === null || param2 === void 0 ? void 0 : param2.outputFormat) && (param1 === null || param1 === void 0 ? void 0 : param1.useShortSuffix) === (param2 === null || param2 === void 0 ? void 0 : param2.useShortSuffix) && (param1 === null || param1 === void 0 ? void 0 : param1.showSuffix) === (param2 === null || param2 === void 0 ? void 0 : param2.showSuffix);
  if ((param2 === null || param2 === void 0 ? void 0 : param2.outputPrecision) !== undefined) {
    return param2.outputPrecision === (param1 === null || param1 === void 0 ? void 0 : param1.outputPrecision) && isSame;
  }
  return isSame;
}
class ObservabilityDataViews {
  constructor(dataViews, adHocDataViews) {
    (0, _defineProperty2.default)(this, "dataViews", void 0);
    (0, _defineProperty2.default)(this, "adHocDataViews", false);
    this.dataViews = dataViews;
    this.adHocDataViews = adHocDataViews !== null && adHocDataViews !== void 0 ? adHocDataViews : false;
  }
  async createDataView(app, indices) {
    const appIndicesPattern = getAppIndicesWithPattern(app, indices);
    const {
      runtimeFields
    } = getFieldFormatsForApp(app);
    const id = getAppDataViewId(app, indices);
    try {
      const dataView = await this.dataViews.create({
        id,
        title: appIndicesPattern,
        timeFieldName: '@timestamp',
        fieldFormats: this.getFieldFormats(app),
        name: _labels.DataTypesLabels[app],
        allowNoIndex: true
      }, false, false);
      if (dataView.matchedIndices.length === 0) {
        throw new _common.DataViewMissingIndices('No indices match pattern');
      }
      if (runtimeFields !== null) {
        runtimeFields.forEach(({
          name,
          field
        }) => {
          dataView.addRuntimeField(name, field);
        });
      }
      return dataView;
    } catch (e) {
      if (e instanceof _common.DataViewMissingIndices) {
        this.dataViews.clearInstanceCache(id);
      }
    }
  }
  async createAndSavedDataView(app, indices) {
    const appIndicesPattern = getAppIndicesWithPattern(app, indices);
    const dataViewId = getAppDataViewId(app, indices);
    return await this.dataViews.createAndSave({
      title: appIndicesPattern,
      id: dataViewId,
      timeFieldName: '@timestamp',
      fieldFormats: this.getFieldFormats(app),
      name: _labels.DataTypesLabels[app],
      allowNoIndex: true
    });
  }
  // we want to make sure field formats remain same
  async validateFieldFormats(app, dataView) {
    const {
      formats: defaultFieldFormats,
      runtimeFields
    } = getFieldFormatsForApp(app);
    if (defaultFieldFormats && defaultFieldFormats.length > 0) {
      let isParamsDifferent = false;
      defaultFieldFormats.forEach(({
        field,
        format
      }) => {
        const fieldByName = dataView.getFieldByName(field);
        if (fieldByName) {
          const fieldFormat = dataView.getFormatterForField(fieldByName);
          const params = fieldFormat.params();
          if (!isParamsSame(params, format.params) || format.id !== fieldFormat.type.id) {
            dataView.setFieldFormat(field, format);
            isParamsDifferent = true;
          }
        }
      });
      let hasNewRuntimeField = false;
      if (runtimeFields !== null) {
        const allRunTimeFields = dataView.getAllRuntimeFields();
        runtimeFields.forEach(({
          name,
          field
        }) => {
          if (!allRunTimeFields[name]) {
            hasNewRuntimeField = true;
            dataView.addRuntimeField(name, field);
          }
        });
      }
      if (isParamsDifferent || hasNewRuntimeField) {
        var _this$dataViews;
        await ((_this$dataViews = this.dataViews) === null || _this$dataViews === void 0 ? void 0 : _this$dataViews.updateSavedObject(dataView));
      }
    }
  }
  getFieldFormats(app) {
    var _appFieldFormats$app;
    const fieldFormatMap = {};
    ((_appFieldFormats$app = appFieldFormats === null || appFieldFormats === void 0 ? void 0 : appFieldFormats[app]) !== null && _appFieldFormats$app !== void 0 ? _appFieldFormats$app : []).forEach(({
      field,
      format
    }) => {
      fieldFormatMap[field] = format;
    });
    return fieldFormatMap;
  }
  async getDataView(app, indices) {
    let appIndices = indices;
    let hasData = false;
    if (!appIndices) {
      const {
        indices: indicesT,
        hasData: hData
      } = await getDataTypeIndices(app);
      hasData = hData;
      appIndices = indicesT;
    }
    if (appIndices && (hasData || indices)) {
      try {
        var _this$dataViews2;
        const dataViewId = getAppDataViewId(app, appIndices);
        const dataViewTitle = getAppIndicesWithPattern(app, appIndices);
        // we will get the data view by id

        if (this.adHocDataViews) {
          return await this.createDataView(app, appIndices);
        }
        const dataView = await ((_this$dataViews2 = this.dataViews) === null || _this$dataViews2 === void 0 ? void 0 : _this$dataViews2.get(dataViewId));

        // and make sure title matches, otherwise, we will need to create it
        if (dataView.title !== dataViewTitle) {
          return await this.createAndSavedDataView(app, appIndices);
        }

        // this is intentional a non blocking call, so no await clause
        this.validateFieldFormats(app, dataView);
        return dataView;
      } catch (e) {
        if (e instanceof _public.SavedObjectNotFound) {
          return await this.createAndSavedDataView(app, appIndices);
        }
      }
    }
  }
}

// eslint-disable-next-line import/no-default-export
exports.ObservabilityDataViews = ObservabilityDataViews;
var _default = ObservabilityDataViews;
exports.default = _default;