"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNoDataConfig = getNoDataConfig;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getNoDataConfig({
  docsLink,
  basePath,
  hasData
}) {
  if (hasData === false) {
    return {
      solution: _i18n.i18n.translate('xpack.exploratoryView.noDataConfig.solutionName', {
        defaultMessage: 'Observability'
      }),
      action: {
        elasticAgent: {
          title: _i18n.i18n.translate('xpack.exploratoryView.noDataConfig.beatsCard.title', {
            defaultMessage: 'Add integrations'
          }),
          description: _i18n.i18n.translate('xpack.exploratoryView.noDataConfig.beatsCard.description', {
            defaultMessage: 'Use Beats and APM agents to send observability data to Elasticsearch. We make it easy with support for many popular systems, apps, and languages.'
          }),
          href: basePath.prepend(`/app/integrations/browse`)
        }
      },
      docsLink
    };
  }
}