"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useQueryParams = useQueryParams;
var _reactRouterDom = require("react-router-dom");
var _react = require("react");
var _queryString = require("query-string");
var _use_kibana_ui_settings = require("./use_kibana_ui_settings");
var _date = require("../utils/date");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getParsedParams = search => {
  return search ? (0, _queryString.parse)(search[0] === '?' ? search.slice(1) : search, {
    sort: false
  }) : {};
};
function useQueryParams() {
  const {
    from,
    to
  } = (0, _use_kibana_ui_settings.useKibanaUISettings)(_use_kibana_ui_settings.UI_SETTINGS.TIMEPICKER_TIME_DEFAULTS);
  const {
    rangeFrom,
    rangeTo
  } = getParsedParams((0, _reactRouterDom.useLocation)().search);
  return (0, _react.useMemo)(() => {
    var _ref, _ref2, _ref3, _ref4;
    return {
      start: (_ref = rangeFrom) !== null && _ref !== void 0 ? _ref : from,
      end: (_ref2 = rangeTo) !== null && _ref2 !== void 0 ? _ref2 : to,
      absStart: (0, _date.getAbsoluteTime)((_ref3 = rangeFrom) !== null && _ref3 !== void 0 ? _ref3 : from),
      absEnd: (0, _date.getAbsoluteTime)((_ref4 = rangeTo) !== null && _ref4 !== void 0 ? _ref4 : to, {
        roundUp: true
      })
    };
  }, [rangeFrom, rangeTo, from, to]);
}