"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InspectorContext = void 0;
exports.InspectorContextProvider = InspectorContextProvider;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _common = require("@kbn/inspector-plugin/common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const value = {
  addInspectorRequest: () => {},
  inspectorAdapters: {
    requests: new _common.RequestAdapter()
  }
};
const InspectorContext = /*#__PURE__*/(0, _react.createContext)(value);
exports.InspectorContext = InspectorContext;
function InspectorContextProvider({
  children
}) {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    inspectorAdapters
  } = value;
  function addInspectorRequest(result) {
    var _ref, _result$data$_inspect, _result$data, _result$data2, _result$data2$mainSta;
    const operations = (_ref = (_result$data$_inspect = (_result$data = result.data) === null || _result$data === void 0 ? void 0 : _result$data._inspect) !== null && _result$data$_inspect !== void 0 ? _result$data$_inspect : (_result$data2 = result.data) === null || _result$data2 === void 0 ? void 0 : (_result$data2$mainSta = _result$data2.mainStatisticsData) === null || _result$data2$mainSta === void 0 ? void 0 : _result$data2$mainSta._inspect) !== null && _ref !== void 0 ? _ref : [];
    operations.forEach(operation => {
      if (operation.response) {
        const {
          id,
          name
        } = operation;
        const requestParams = {
          id,
          name
        };
        const requestResponder = inspectorAdapters.requests.start(id, requestParams, operation.startTime);
        requestResponder.json(operation.json);
        if (operation.stats) {
          requestResponder.stats(operation.stats);
        }
        requestResponder.finish(operation.status, operation.response);
      }
    });
  }
  (0, _react.useEffect)(() => {
    const unregisterCallback = history.listen(newLocation => {
      if (history.location.pathname !== newLocation.pathname) {
        inspectorAdapters.requests.reset();
      }
    });
    return () => {
      unregisterCallback();
    };
  }, [history, inspectorAdapters]);
  return /*#__PURE__*/_react.default.createElement(InspectorContext.Provider, {
    value: {
      ...value,
      addInspectorRequest
    }
  }, children);
}