"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HasDataContext = void 0;
exports.HasDataContextProvider = HasDataContextProvider;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("./constants");
var _use_fetcher = require("../hooks/use_fetcher");
var _get_observability_alerts = require("../services/get_observability_alerts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HasDataContext = /*#__PURE__*/(0, _react.createContext)({});
exports.HasDataContext = HasDataContext;
const apps = [_constants.APM_APP, _constants.UPTIME_APP, _constants.INFRA_LOGS_APP, _constants.INFRA_METRICS_APP, _constants.UX_APP, _constants.ALERT_APP];
function HasDataContextProvider({
  children
}) {
  const {
    http
  } = (0, _public.useKibana)().services;
  const [forceUpdate, setForceUpdate] = (0, _react.useState)('');
  const [hasDataMap, setHasDataMap] = (0, _react.useState)({});
  (0, _react.useEffect)(() => {
    async function fetchAlerts() {
      try {
        const alerts = await (0, _get_observability_alerts.getObservabilityAlerts)({
          http
        });
        setHasDataMap(prevState => ({
          ...prevState,
          [_constants.ALERT_APP]: {
            hasData: alerts.length > 0,
            status: _use_fetcher.FETCH_STATUS.SUCCESS
          }
        }));
      } catch (e) {
        setHasDataMap(prevState => ({
          ...prevState,
          [_constants.ALERT_APP]: {
            hasData: undefined,
            status: _use_fetcher.FETCH_STATUS.FAILURE
          }
        }));
      }
    }
    fetchAlerts();
  }, [forceUpdate, http]);
  const isAllRequestsComplete = apps.every(app => {
    var _hasDataMap$app;
    const appStatus = (_hasDataMap$app = hasDataMap[app]) === null || _hasDataMap$app === void 0 ? void 0 : _hasDataMap$app.status;
    return appStatus !== undefined && appStatus !== _use_fetcher.FETCH_STATUS.LOADING;
  });
  const hasAnyData = Object.keys(hasDataMap).some(app => {
    var _hasDataMap$app2;
    const appHasData = (_hasDataMap$app2 = hasDataMap[app]) === null || _hasDataMap$app2 === void 0 ? void 0 : _hasDataMap$app2.hasData;
    return appHasData === true;
  });
  return /*#__PURE__*/_react.default.createElement(HasDataContext.Provider, {
    value: {
      hasDataMap,
      hasAnyData: (0, _lodash.isEmpty)(hasDataMap) ? undefined : hasAnyData,
      isAllRequestsComplete,
      forceUpdate,
      onRefreshTimeRange: () => {
        setForceUpdate((0, _lodash.uniqueId)());
      }
    },
    children: children
  });
}