"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = LoadWhenInView;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _useIntersection = _interopRequireDefault(require("react-use/lib/useIntersection"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line import/no-default-export
function LoadWhenInView({
  children,
  placeholderTitle,
  initialHeight = 100
}) {
  const intersectionRef = _react.default.useRef(null);
  const intersection = (0, _useIntersection.default)(intersectionRef, {
    root: null,
    rootMargin: '0px',
    threshold: 0.25
  });
  const [isVisible, setIsVisible] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (intersection && intersection.intersectionRatio > 0.25) {
      setIsVisible(true);
    }
  }, [intersection, intersection === null || intersection === void 0 ? void 0 : intersection.intersectionRatio]);
  return isVisible ? children : /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "renderOnlyInViewPlaceholderContainer",
    ref: intersectionRef,
    role: "region",
    "aria-label": placeholderTitle,
    style: {
      height: initialHeight
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingContent, null));
}
module.exports = exports.default;