"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.trackTelemetryOnLoad = exports.trackTelemetryOnApply = exports.trackChartLoadingTime = void 0;
var _use_track_metric = require("../../../../hooks/use_track_metric");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const trackTelemetryOnApply = (trackEvent, allSeries, reportType) => {
  trackFilters(trackEvent, allSeries, reportType);
  trackDataType(trackEvent, allSeries, reportType);
  trackApplyChanges(trackEvent);
};
exports.trackTelemetryOnApply = trackTelemetryOnApply;
const trackTelemetryOnLoad = (trackEvent, start, end) => {
  trackChartLoadingTime(trackEvent, start, end);
};
exports.trackTelemetryOnLoad = trackTelemetryOnLoad;
const getAppliedFilters = allSeries => {
  const filtersByDataType = new Map();
  allSeries.forEach(series => {
    const seriesFilters = filtersByDataType.get(series.dataType);
    const filterFields = (series.filters || []).map(filter => filter.field);
    if (seriesFilters) {
      seriesFilters.push(...filterFields);
    } else {
      filtersByDataType.set(series.dataType, [...filterFields]);
    }
  });
  return filtersByDataType;
};
const trackFilters = (trackEvent, allSeries, reportType) => {
  const filtersByDataType = getAppliedFilters(allSeries);
  [...filtersByDataType.keys()].forEach(dataType => {
    const filtersForDataType = filtersByDataType.get(dataType);
    (filtersForDataType || []).forEach(filter => {
      trackEvent({
        app: 'observability-overview',
        metricType: _use_track_metric.METRIC_TYPE.COUNT,
        metric: `exploratory_view__filters__filter_${filter}`
      });
      trackEvent({
        app: 'observability-overview',
        metricType: _use_track_metric.METRIC_TYPE.COUNT,
        metric: `exploratory_view__filters__report_type_${reportType}__data_type_${dataType}__filter_${filter}`
      });
    });
  });
};
const trackApplyChanges = trackEvent => {
  trackEvent({
    app: 'observability-overview',
    metricType: _use_track_metric.METRIC_TYPE.COUNT,
    metric: 'exploratory_view_apply_changes'
  });
};
const trackDataType = (trackEvent, allSeries, reportType) => {
  const metrics = allSeries.map(series => ({
    dataType: series.dataType,
    metricType: series.selectedMetricField
  }));
  metrics.forEach(({
    dataType,
    metricType
  }) => {
    if (reportType && dataType && metricType) {
      trackEvent({
        app: 'observability-overview',
        metricType: _use_track_metric.METRIC_TYPE.COUNT,
        metric: `exploratory_view__report_type_${reportType}__data_type_${dataType}__metric_type_${metricType}`
      });
    }
  });
};
const trackChartLoadingTime = (trackEvent, start, end) => {
  const secondsLoading = (end - start) / 1000;
  const rangeStr = toRangeStr(secondsLoading);
  if (rangeStr) {
    trackChartLoadingMetric(trackEvent, rangeStr);
  }
};
exports.trackChartLoadingTime = trackChartLoadingTime;
function toRangeStr(n) {
  if (n < 0 || isNaN(n)) return null;
  if (n >= 60) return '60+';else if (n >= 30) return '30-60';else if (n >= 20) return '20-30';else if (n >= 10) return '10-20';else if (n >= 5) return '5-10';
  return '0-5';
}
const trackChartLoadingMetric = (trackEvent, range) => {
  trackEvent({
    app: 'observability-overview',
    metricType: _use_track_metric.METRIC_TYPE.COUNT,
    metric: `exploratory_view__chart_loading_in_seconds_${range}`
  });
};