"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MockKibanaProvider = MockKibanaProvider;
exports.MockRouter = MockRouter;
exports.mockUseHasData = exports.mockHistory = exports.mockFetcher = exports.mockDataView = exports.mockCore = exports.mockAppDataView = exports.getHistoryFromUrl = exports.forNearestButton = void 0;
exports.mockUseSeriesFilter = mockUseSeriesFilter;
exports.mockUxSeries = exports.mockUseValuesList = void 0;
exports.render = render;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _rxjs = require("rxjs");
var _react = _interopRequireDefault(require("react"));
var _queryString = require("query-string");
var _react2 = require("@testing-library/react");
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _history = require("history");
var _i18nReact = require("@kbn/i18n-react");
var _mocks = require("@kbn/core/public/mocks");
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/kibana-react-plugin/common");
var _mocks2 = require("@kbn/lens-plugin/public/mocks");
var _services = require("@kbn/unified-search-plugin/public/services");
var _stubs = require("@kbn/data-views-plugin/common/stubs");
var _mocks3 = require("@kbn/data-plugin/public/mocks");
var _mocks4 = require("@kbn/data-views-plugin/public/mocks");
var _mocks5 = require("@kbn/cases-plugin/public/mocks");
var _field_formats = require("./configurations/rum/field_formats");
var useAppDataViewHook = _interopRequireWildcard(require("./hooks/use_app_data_view"));
var _use_series_storage = require("./hooks/use_series_storage");
var fetcherHook = _interopRequireWildcard(require("../../../hooks/use_fetcher"));
var useSeriesFilterHook = _interopRequireWildcard(require("./hooks/use_series_filters"));
var useHasDataHook = _interopRequireWildcard(require("../../../hooks/use_has_data"));
var useValuesListHook = _interopRequireWildcard(require("../../../hooks/use_values_list"));
var _test_data_view = _interopRequireDefault(require("./configurations/test_data/test_data_view.json"));
var _elasticsearch_fieldnames = require("./configurations/constants/elasticsearch_fieldnames");
var _obsv_exploratory_view = require("./obsv_exploratory_view");
var _exploratory_view_config = require("./contexts/exploratory_view_config");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line import/no-extraneous-dependencies

function getSetting(key) {
  if (key === 'timepicker:quickRanges') {
    return [{
      display: 'Today',
      from: 'now/d',
      to: 'now/d'
    }];
  }
  return 'MMM D, YYYY @ HH:mm:ss.SSS';
}
function setSetting$(key) {
  return (0, _rxjs.of)('MMM D, YYYY @ HH:mm:ss.SSS');
}

/* default mock core */
const defaultCore = _mocks.coreMock.createStart();
const mockCore = () => {
  const core = {
    ...defaultCore,
    application: {
      ...defaultCore.application,
      getUrlForApp: () => '/app/exploratory-view',
      navigateToUrl: jest.fn(),
      capabilities: {
        ...defaultCore.application.capabilities,
        observability: {
          'alerting:save': true,
          configureSettings: true,
          save: true,
          show: true
        }
      }
    },
    uiSettings: {
      ...defaultCore.uiSettings,
      get: getSetting,
      get$: setSetting$
    },
    lens: _mocks2.lensPluginMock.createStartContract(),
    data: _mocks3.dataPluginMock.createStartContract(),
    dataViews: _mocks4.dataViewPluginMocks.createStartContract(),
    cases: _mocks5.casesPluginMock.createStartContract()
  };
  return core;
};

/* Mock Provider Components */
exports.mockCore = mockCore;
function MockKibanaProvider({
  children,
  core,
  kibanaProps
}) {
  const dataView = mockDataView;
  (0, _services.setIndexPatterns)({
    ...[dataView],
    get: async () => dataView
  });
  return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, (0, _extends2.default)({
    services: {
      ...core
    }
  }, kibanaProps), /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(useAppDataViewHook.DataViewContextProvider, null, children))));
}
function MockRouter({
  children,
  core,
  history = (0, _history.createMemoryHistory)(),
  kibanaProps
}) {
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: '/app/exploratory-view/'
  }, /*#__PURE__*/_react.default.createElement(MockKibanaProvider, {
    core: core,
    kibanaProps: kibanaProps,
    history: history
  }, children)));
}

/* Custom react testing library render */
function render(ui, {
  history = (0, _history.createMemoryHistory)(),
  core: customCore,
  kibanaProps,
  renderOptions,
  url = '/app/exploratory-view/',
  initSeries = {}
} = {}) {
  if (url) {
    history = getHistoryFromUrl(url);
  }
  const core = {
    ...mockCore(),
    ...customCore
  };
  const seriesContextValue = mockSeriesStorageContext(initSeries);
  return {
    ...(0, _react2.render)( /*#__PURE__*/_react.default.createElement(MockRouter, {
      history: history,
      kibanaProps: kibanaProps,
      core: core
    }, /*#__PURE__*/_react.default.createElement(_exploratory_view_config.ExploratoryViewContextProvider, {
      reportTypes: _obsv_exploratory_view.reportTypesList,
      dataTypes: _obsv_exploratory_view.dataTypes,
      reportConfigMap: _obsv_exploratory_view.obsvReportConfigMap,
      setHeaderActionMenu: jest.fn(),
      theme$: _mocks.themeServiceMock.createTheme$()
    }, /*#__PURE__*/_react.default.createElement(_use_series_storage.UrlStorageContext.Provider, {
      value: {
        ...seriesContextValue
      }
    }, ui))), renderOptions),
    history,
    core,
    ...seriesContextValue
  };
}
const getHistoryFromUrl = url => {
  if (typeof url === 'string') {
    return (0, _history.createMemoryHistory)({
      initialEntries: [url]
    });
  }
  return (0, _history.createMemoryHistory)({
    initialEntries: [url.path + (0, _queryString.stringify)(url.queryParams)]
  });
};
exports.getHistoryFromUrl = getHistoryFromUrl;
const mockFetcher = data => {
  return jest.spyOn(fetcherHook, 'useFetcher').mockReturnValue({
    data,
    status: fetcherHook.FETCH_STATUS.SUCCESS,
    refetch: jest.fn()
  });
};
exports.mockFetcher = mockFetcher;
const mockUseHasData = () => {
  const onRefreshTimeRange = jest.fn();
  const spy = jest.spyOn(useHasDataHook, 'useHasData').mockReturnValue({
    onRefreshTimeRange
  });
  return {
    spy,
    onRefreshTimeRange
  };
};
exports.mockUseHasData = mockUseHasData;
const mockAppDataView = props => {
  const loadDataView = jest.fn();
  const spy = jest.spyOn(useAppDataViewHook, 'useAppDataViewContext').mockReturnValue({
    dataView: mockDataView,
    hasData: true,
    loading: false,
    hasAppData: {
      ux: true
    },
    loadDataView,
    dataViews: {
      ux: mockDataView
    },
    dataViewErrors: {},
    ...(props || {})
  });
  return {
    spy,
    loadDataView
  };
};
exports.mockAppDataView = mockAppDataView;
const mockUseValuesList = values => {
  const onRefreshTimeRange = jest.fn();
  const spy = jest.spyOn(useValuesListHook, 'useValuesList').mockReturnValue({
    values: values !== null && values !== void 0 ? values : []
  });
  return {
    spy,
    onRefreshTimeRange
  };
};
exports.mockUseValuesList = mockUseValuesList;
const mockUxSeries = {
  name: 'performance-distribution',
  dataType: 'ux',
  breakdown: 'user_agent.name',
  time: {
    from: 'now-15m',
    to: 'now'
  },
  reportDefinitions: {
    'service.name': ['elastic-co']
  },
  selectedMetricField: _elasticsearch_fieldnames.TRANSACTION_DURATION
};
exports.mockUxSeries = mockUxSeries;
function mockSeriesStorageContext({
  data,
  filters,
  breakdown
}) {
  const testSeries = {
    ...mockUxSeries,
    breakdown: breakdown || 'user_agent.name',
    ...(filters ? {
      filters
    } : {})
  };
  const mockDataSeries = data || [testSeries];
  const removeSeries = jest.fn();
  const setSeries = jest.fn();
  const getSeries = jest.fn().mockReturnValue(testSeries);
  return {
    removeSeries,
    setSeries,
    getSeries,
    autoApply: true,
    reportType: 'data-distribution',
    lastRefresh: Date.now(),
    setLastRefresh: jest.fn(),
    setAutoApply: jest.fn(),
    applyChanges: jest.fn(),
    firstSeries: mockDataSeries[0],
    allSeries: mockDataSeries,
    setReportType: jest.fn(),
    setChartTimeRangeContext: jest.fn(),
    storage: {
      get: jest.fn().mockImplementation(key => key === _use_series_storage.reportTypeKey ? 'data-distribution' : mockDataSeries)
    }
  };
}
function mockUseSeriesFilter() {
  const removeFilter = jest.fn();
  const invertFilter = jest.fn();
  const setFilter = jest.fn();
  const replaceFilter = jest.fn();
  const setFiltersWildcard = jest.fn();
  const spy = jest.spyOn(useSeriesFilterHook, 'useSeriesFilters').mockReturnValue({
    removeFilter,
    invertFilter,
    setFilter,
    replaceFilter,
    setFiltersWildcard
  });
  return {
    spy,
    removeFilter,
    invertFilter,
    setFilter,
    replaceFilter,
    setFiltersWildcard
  };
}
const hist = (0, _history.createMemoryHistory)();
const mockHistory = {
  ...hist,
  createHref: jest.fn(({
    pathname
  }) => `/observability${pathname}`),
  push: jest.fn(),
  location: {
    ...hist.location,
    pathname: '/current-path'
  }
};
exports.mockHistory = mockHistory;
const fieldFormatMap = {};
_field_formats.rumFieldFormats.forEach(({
  field,
  format
}) => {
  fieldFormatMap[field] = format;
});
const mockDataView = (0, _stubs.createStubDataView)({
  spec: {
    id: 'apm-*',
    title: 'apm-*',
    timeFieldName: '@timestamp',
    fields: JSON.parse(_test_data_view.default.attributes.fields),
    fieldFormats: fieldFormatMap
  }
});

// This function allows us to query for the nearest button with test
// no matter whether it has nested tags or not (as EuiButton elements do).
exports.mockDataView = mockDataView;
const forNearestButton = getByText => text => getByText((_content, node) => {
  if (!node) return false;
  const noOtherButtonHasText = Array.from(node.children).every(child => child && (child.textContent !== text || child.tagName.toLowerCase() !== 'button'));
  return noOtherButtonHasText && node.textContent === text && node.tagName.toLowerCase() === 'button';
});
exports.forNearestButton = forNearestButton;