"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useExpViewTimeRange = exports.combineTimeRanges = void 0;
var _react = require("react");
var _use_series_storage = require("./use_series_storage");
var _constants = require("../configurations/constants");
var _date_range_picker = require("../components/date_range_picker");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const combineTimeRanges = (reportType, allSeries, firstSeries) => {
  let to = '';
  let from = '';
  if (reportType === _constants.ReportTypes.KPI) {
    return firstSeries === null || firstSeries === void 0 ? void 0 : firstSeries.time;
  }
  allSeries.forEach(series => {
    if (series.dataType && series.selectedMetricField && series.time) {
      const seriesFrom = (0, _date_range_picker.parseRelativeDate)(series.time.from);
      const seriesTo = (0, _date_range_picker.parseRelativeDate)(series.time.to, {
        roundUp: true
      });
      if (!to || seriesTo > (0, _date_range_picker.parseRelativeDate)(to, {
        roundUp: true
      })) {
        to = series.time.to;
      }
      if (!from || seriesFrom < (0, _date_range_picker.parseRelativeDate)(from)) {
        from = series.time.from;
      }
    }
  });
  return {
    to,
    from
  };
};
exports.combineTimeRanges = combineTimeRanges;
const useExpViewTimeRange = () => {
  const {
    storage,
    reportType,
    lastRefresh,
    firstSeries
  } = (0, _use_series_storage.useSeriesStorage)();
  return (0, _react.useMemo)(() => {
    var _storage$get;
    // we only use the data from url to apply, since that get updated to apply changes
    const allSeriesFromUrl = (0, _use_series_storage.convertAllShortSeries)((_storage$get = storage.get(_use_series_storage.allSeriesKey)) !== null && _storage$get !== void 0 ? _storage$get : []);
    const firstSeriesT = allSeriesFromUrl === null || allSeriesFromUrl === void 0 ? void 0 : allSeriesFromUrl[0];
    return firstSeriesT ? combineTimeRanges(reportType, allSeriesFromUrl, firstSeriesT) : undefined;
    // we want to keep last refresh in dependencies to force refresh
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [reportType, storage, lastRefresh, firstSeries]);
};
exports.useExpViewTimeRange = useExpViewTimeRange;