"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDiscoverLink = void 0;
var _react = require("react");
var _kibana_react = require("../../../../utils/kibana_react");
var _use_app_data_view = require("./use_app_data_view");
var _utils = require("../configurations/utils");
var _use_lens_attributes = require("./use_lens_attributes");
var _constants = require("../configurations/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDiscoverLink = ({
  series,
  seriesConfig
}) => {
  var _kServices$discover;
  const kServices = (0, _kibana_react.useKibana)().services;
  const {
    application: {
      navigateToUrl
    }
  } = kServices;
  const {
    dataViews
  } = (0, _use_app_data_view.useAppDataViewContext)();
  const locator = (_kServices$discover = kServices.discover) === null || _kServices$discover === void 0 ? void 0 : _kServices$discover.locator;
  const [discoverUrl, setDiscoverUrl] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    const dataView = dataViews === null || dataViews === void 0 ? void 0 : dataViews[series.dataType];
    if (dataView) {
      var _series$reportDefinit, _series$filters;
      const definitions = (_series$reportDefinit = series.reportDefinitions) !== null && _series$reportDefinit !== void 0 ? _series$reportDefinit : {};
      const urlFilters = ((_series$filters = series.filters) !== null && _series$filters !== void 0 ? _series$filters : []).concat((0, _use_lens_attributes.getFiltersFromDefs)(definitions));
      const filters = (0, _utils.urlFilterToPersistedFilter)({
        dataView,
        urlFilters,
        initFilters: seriesConfig === null || seriesConfig === void 0 ? void 0 : seriesConfig.baseFilters
      });
      const selectedMetricField = series.selectedMetricField;
      if (selectedMetricField && selectedMetricField !== _constants.RECORDS_FIELD && selectedMetricField !== _constants.RECORDS_PERCENTAGE_FIELD) {
        filters.push((0, _utils.buildExistsFilter)(selectedMetricField, dataView)[0]);
      }
      const getDiscoverUrl = async () => {
        if (!locator) return;
        const newUrl = await locator.getUrl({
          filters,
          indexPatternId: dataView === null || dataView === void 0 ? void 0 : dataView.id
        });
        setDiscoverUrl(newUrl);
      };
      getDiscoverUrl();
    }
  }, [dataViews, series.dataType, series.filters, series.reportDefinitions, series.selectedMetricField, seriesConfig === null || seriesConfig === void 0 ? void 0 : seriesConfig.baseFilters, locator]);
  const onClick = (0, _react.useCallback)(event => {
    if (discoverUrl) {
      event.preventDefault();
      return navigateToUrl(discoverUrl);
    }
  }, [discoverUrl, navigateToUrl]);
  return {
    href: discoverUrl,
    onClick
  };
};
exports.useDiscoverLink = useDiscoverLink;