"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddToCaseAction = AddToCaseAction;
exports.CaseToastText = CaseToastText;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/cases-plugin/public");
var _public3 = require("@kbn/observability-shared-plugin/public");
var _use_get_user_cases_permissions = require("../../../../hooks/use_get_user_cases_permissions");
var _use_add_to_case = require("../hooks/use_add_to_case");
var _date_range_picker = require("../components/date_range_picker");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AddToCaseAction({
  appId,
  autoOpen,
  lensAttributes,
  owner = _public3.observabilityFeatureId,
  setAutoOpen,
  timeRange
}) {
  var _absoluteFromDate$toI, _absoluteToDate$toISO;
  const kServices = (0, _public.useKibana)().services;
  const userCasesPermissions = (0, _use_get_user_cases_permissions.useGetUserCasesPermissions)();
  const {
    cases,
    application: {
      getUrlForApp
    },
    theme
  } = kServices;
  const getToastText = (0, _react.useCallback)(theCase => (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(CaseToastText, {
    linkUrl: getUrlForApp(appId !== null && appId !== void 0 ? appId : _public3.observabilityAppId, {
      deepLinkId: _public2.CasesDeepLinkId.cases,
      path: (0, _public2.generateCaseViewPath)({
        detailName: theCase.id
      })
    })
  }), {
    theme$: theme === null || theme === void 0 ? void 0 : theme.theme$
  }), [appId, getUrlForApp, theme === null || theme === void 0 ? void 0 : theme.theme$]);
  const absoluteFromDate = (0, _date_range_picker.parseRelativeDate)(timeRange.from);
  const absoluteToDate = (0, _date_range_picker.parseRelativeDate)(timeRange.to, {
    roundUp: true
  });
  const {
    onCaseClicked,
    isCasesOpen,
    setIsCasesOpen,
    isSaving
  } = (0, _use_add_to_case.useAddToCase)({
    lensAttributes,
    getToastText,
    timeRange: {
      from: (_absoluteFromDate$toI = absoluteFromDate === null || absoluteFromDate === void 0 ? void 0 : absoluteFromDate.toISOString()) !== null && _absoluteFromDate$toI !== void 0 ? _absoluteFromDate$toI : '',
      to: (_absoluteToDate$toISO = absoluteToDate === null || absoluteToDate === void 0 ? void 0 : absoluteToDate.toISOString()) !== null && _absoluteToDate$toISO !== void 0 ? _absoluteToDate$toISO : ''
    },
    appId,
    owner
  });
  const getAllCasesSelectorModalProps = {
    permissions: userCasesPermissions,
    onRowClick: onCaseClicked,
    owner: [owner],
    onClose: () => {
      setIsCasesOpen(false);
    }
  };
  (0, _react.useEffect)(() => {
    if (autoOpen) {
      setIsCasesOpen(true);
    }
  }, [autoOpen, setIsCasesOpen]);
  (0, _react.useEffect)(() => {
    if (!isCasesOpen) {
      setAutoOpen === null || setAutoOpen === void 0 ? void 0 : setAutoOpen(false);
    }
  }, [isCasesOpen, setAutoOpen]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, typeof autoOpen === 'undefined' && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "o11yAddToCaseActionAddToCaseButton",
    size: "s",
    isLoading: isSaving,
    isDisabled: lensAttributes === null,
    onClick: () => {
      if (lensAttributes) {
        setIsCasesOpen(true);
      }
    }
  }, _i18n.i18n.translate('xpack.exploratoryView.expView.heading.addToCase', {
    defaultMessage: 'Add to case'
  })), isCasesOpen && lensAttributes && cases.ui.getAllCasesSelectorModal(getAllCasesSelectorModalProps));
}
function CaseToastText({
  linkUrl
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "o11yCaseToastTextViewCaseLink",
    href: linkUrl,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.exploratoryView.expView.heading.addToCase.notification.viewCase', {
    defaultMessage: 'View case'
  }))));
}