"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLocalDataView = useLocalDataView;
var _react = require("react");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _observability_data_views = require("../../../../utils/observability_data_views");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useLocalDataView(seriesDataType, dataTypesIndexPatterns) {
  const [dataViewTitle, setDataViewTitle] = (0, _useLocalStorage.default)(`${seriesDataType}AppDataViewTitle`, '');
  const initDatViewTitle = dataTypesIndexPatterns === null || dataTypesIndexPatterns === void 0 ? void 0 : dataTypesIndexPatterns[seriesDataType];
  const {
    data: updatedDataViewTitle
  } = (0, _use_fetcher.useFetcher)(async () => {
    if (initDatViewTitle) {
      return initDatViewTitle;
    }
    return (await (0, _observability_data_views.getDataTypeIndices)(seriesDataType)).indices;
  }, [initDatViewTitle, seriesDataType]);
  (0, _react.useEffect)(() => {
    if (updatedDataViewTitle) {
      setDataViewTitle(updatedDataViewTitle);
    }
  }, [setDataViewTitle, updatedDataViewTitle]);
  return {
    dataViewTitle: dataViewTitle || initDatViewTitle
  };
}