"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useActions = useActions;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _utils = require("../configurations/utils");
var _exploratory_view_url = require("../configurations/exploratory_view_url");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useActions({
  withActions,
  attributes,
  reportType,
  setIsSaveOpen,
  setAddToCaseOpen,
  appId = 'observability',
  timeRange,
  lensAttributes
}) {
  const kServices = (0, _public.useKibana)().services;
  const {
    lens
  } = kServices;
  const [defaultActions, setDefaultActions] = (0, _react.useState)(['explore', 'save', 'addToCase']);
  (0, _react.useEffect)(() => {
    if (withActions === false) {
      setDefaultActions([]);
    }
    if (Array.isArray(withActions)) {
      setDefaultActions(withActions);
    }
  }, [withActions]);
  const {
    http,
    application
  } = (0, _public.useKibana)().services;
  const href = (0, _exploratory_view_url.createExploratoryViewUrl)({
    reportType,
    allSeries: attributes
  }, http === null || http === void 0 ? void 0 : http.basePath.get());
  const routePath = (0, _utils.createExploratoryViewRoutePath)({
    reportType,
    allSeries: attributes
  });
  const openInLensCallback = (0, _react.useCallback)(() => {
    if (lensAttributes) {
      lens.navigateToPrefilledEditor({
        id: '',
        timeRange,
        attributes: lensAttributes
      }, {
        openInNewTab: true
      });
    }
  }, [lens, lensAttributes, timeRange]);
  const exploreCallback = (0, _react.useCallback)(() => {
    application === null || application === void 0 ? void 0 : application.navigateToApp(appId, {
      path: routePath
    });
  }, [appId, application, routePath]);
  const saveCallback = (0, _react.useCallback)(() => {
    setIsSaveOpen(true);
  }, [setIsSaveOpen]);
  const addToCaseCallback = (0, _react.useCallback)(() => {
    setAddToCaseOpen(true);
  }, [setAddToCaseOpen]);
  return defaultActions.map(action => {
    if (action === 'save') {
      return getSaveAction({
        callback: saveCallback
      });
    }
    if (action === 'addToCase') {
      return getAddToCaseAction({
        callback: addToCaseCallback
      });
    }
    if (action === 'openInLens') {
      return getOpenInLensAction({
        callback: openInLensCallback
      });
    }
    return getExploreAction({
      href,
      callback: exploreCallback
    });
  });
}
const getOpenInLensAction = ({
  callback
}) => {
  return {
    id: 'expViewOpenInLens',
    getDisplayName(context) {
      return _i18n.i18n.translate('xpack.exploratoryView.expView.openInLens', {
        defaultMessage: 'Open in Lens'
      });
    },
    getIconType(context) {
      return 'visArea';
    },
    type: 'link',
    async isCompatible(context) {
      return true;
    },
    async execute(context) {
      callback();
      return;
    }
  };
};
const getExploreAction = ({
  href,
  callback
}) => {
  return {
    id: 'expViewExplore',
    getDisplayName(context) {
      return _i18n.i18n.translate('xpack.exploratoryView.expView.explore', {
        defaultMessage: 'Explore'
      });
    },
    getIconType(context) {
      return 'visArea';
    },
    type: 'link',
    async isCompatible(context) {
      return true;
    },
    async getHref(context) {
      return href;
    },
    async execute(context) {
      callback();
      return;
    },
    order: 50
  };
};
const getSaveAction = ({
  callback
}) => {
  return {
    id: 'expViewSave',
    getDisplayName(context) {
      return _i18n.i18n.translate('xpack.exploratoryView.expView.save', {
        defaultMessage: 'Save visualization'
      });
    },
    getIconType(context) {
      return 'save';
    },
    type: 'actionButton',
    async isCompatible(context) {
      return true;
    },
    async execute(context) {
      callback();
      return;
    },
    order: 49
  };
};
const getAddToCaseAction = ({
  callback
}) => {
  return {
    id: 'expViewAddToCase',
    getDisplayName(context) {
      return _i18n.i18n.translate('xpack.exploratoryView.expView.addToCase', {
        defaultMessage: 'Add to case'
      });
    },
    getIconType(context) {
      return 'link';
    },
    type: 'actionButton',
    async isCompatible(context) {
      return true;
    },
    async execute(context) {
      callback();
      return;
    },
    order: 48
  };
};