"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExploratoryViewEmbeddable = getExploratoryViewEmbeddable;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/kibana-react-plugin/public");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_app_data_view = require("./use_app_data_view");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const Embeddable = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./embeddable'))));
function ExploratoryViewEmbeddable(props) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
  }, /*#__PURE__*/_react.default.createElement(Embeddable, props));
}
function getExploratoryViewEmbeddable(services) {
  const {
    lens,
    dataViews: dataViewsService,
    uiSettings
  } = services;
  const dataViewCache = {};
  const lenStateHelperPromise = null;
  const lastRefreshed = {};
  const hasSameTimeRange = props => {
    const {
      attributes
    } = props;
    if (!attributes || (attributes === null || attributes === void 0 ? void 0 : attributes.length) === 0) {
      return false;
    }
    const series = attributes[0];
    const {
      time
    } = series;
    const {
      from,
      to
    } = time;
    return attributes.every(seriesT => {
      const {
        time: timeT
      } = seriesT;
      return timeT.from === from && timeT.to === to;
    });
  };
  return props => {
    (0, _react.useEffect)(() => {
      if (!services.data.search.session.getSessionId()) {
        services.data.search.session.start();
      }
    }, []);
    const {
      dataTypesIndexPatterns,
      attributes,
      customHeight
    } = props;
    if (!dataViewsService || !lens || !attributes || (attributes === null || attributes === void 0 ? void 0 : attributes.length) === 0) {
      return null;
    }
    const series = attributes[0];
    const isDarkMode = uiSettings === null || uiSettings === void 0 ? void 0 : uiSettings.get('theme:darkMode');
    const {
      data: lensHelper,
      loading: lensLoading
    } = (0, _use_fetcher.useFetcher)(async () => {
      if (lenStateHelperPromise) {
        return lenStateHelperPromise;
      }
      return lens.stateHelperApi();
    }, []);
    const [loadCount, setLoadCount] = (0, _react.useState)(0);
    const onLensLoaded = (0, _react.useCallback)(lensLoaded => {
      if (lensLoaded && props.id && hasSameTimeRange(props) && !lastRefreshed[props.id]) {
        lastRefreshed[props.id] = series.time;
      }
      setLoadCount(prev => prev + 1);
    }, [props, series.time]);
    const {
      dataViews,
      loading
    } = (0, _use_app_data_view.useAppDataView)({
      series,
      dataViewCache,
      dataViewsService,
      dataTypesIndexPatterns,
      seriesDataType: series === null || series === void 0 ? void 0 : series.dataType
    });
    const embedProps = (0, _react.useMemo)(() => {
      const newProps = {
        ...props
      };
      if (props.sparklineMode) {
        newProps.axisTitlesVisibility = {
          x: false,
          yRight: false,
          yLeft: false
        };
        newProps.legendIsVisible = false;
        newProps.hideTicks = true;
      }
      if (props.id && lastRefreshed[props.id] && loadCount < 2) {
        var _props$attributes;
        newProps.attributes = (_props$attributes = props.attributes) === null || _props$attributes === void 0 ? void 0 : _props$attributes.map(seriesT => ({
          ...seriesT,
          time: lastRefreshed[props.id]
        }));
      } else if (props.id) {
        lastRefreshed[props.id] = series.time;
      }
      return newProps;
    }, [loadCount, props, series.time]);
    if (Object.keys(dataViews).length === 0 || loading || !lensHelper || lensLoading) {
      return /*#__PURE__*/_react.default.createElement(LoadingWrapper, {
        customHeight: customHeight
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "l"
      }));
    }
    if (!dataViews[series === null || series === void 0 ? void 0 : series.dataType]) {
      return /*#__PURE__*/_react.default.createElement(EmptyState, {
        height: props.customHeight
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
      darkMode: isDarkMode
    }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
      services: services
    }, /*#__PURE__*/_react.default.createElement(Wrapper, {
      customHeight: props.customHeight,
      "data-test-subj": props.dataTestSubj
    }, /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, (0, _extends2.default)({}, embedProps, {
      dataViewState: dataViews,
      lens: lens,
      lensFormulaHelper: lensHelper === null || lensHelper === void 0 ? void 0 : lensHelper.formula,
      searchSessionId: services.data.search.session.getSessionId(),
      onLoad: onLensLoaded
    }))))));
  };
}
const Wrapper = _styledComponents.default.div`
  height: ${props => props.customHeight ? `${props.customHeight};` : `100%;`};
`;
const LoadingWrapper = _styledComponents.default.div`
  height: ${props => props.customHeight ? `${props.customHeight};` : `100%;`};
  display: flex;
  align-items: center;
  justify-content: center;
`;
function EmptyState({
  height
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    style: {
      height: height !== null && height !== void 0 ? height : '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", null, NO_DATA_LABEL)));
}
const NO_DATA_LABEL = _i18n.i18n.translate('xpack.exploratoryView.noData', {
  defaultMessage: 'No data'
});