"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Embeddable;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/embeddable-plugin/common");
var _public = require("@kbn/observability-shared-plugin/public");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_kibana_space = require("../../../../hooks/use_kibana_space");
var _heatmap_attributes = require("../configurations/lens_attributes/heatmap_attributes");
var _single_metric_attributes = require("../configurations/lens_attributes/single_metric_attributes");
var _ = require("../../../..");
var _use_theme = require("../../../../hooks/use_theme");
var _lens_attributes = require("../configurations/lens_attributes");
var _use_lens_attributes = require("../hooks/use_lens_attributes");
var _operation_type_select = require("../series_editor/columns/operation_type_select");
var _obsv_exploratory_view = require("../obsv_exploratory_view");
var _use_actions = require("./use_actions");
var _add_to_case_action = require("../header/add_to_case_action");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line import/no-default-export
function Embeddable({
  appId,
  appendTitle,
  attributes = [],
  axisTitlesVisibility,
  gridlinesVisibilitySettings,
  customHeight,
  customLensAttrs,
  customTimeRange,
  dataViewState,
  legendIsVisible,
  legendPosition,
  lens,
  onBrushEnd,
  caseOwner = _public.observabilityFeatureId,
  reportConfigMap = {},
  reportType,
  showCalculationMethod = false,
  title,
  withActions = true,
  lensFormulaHelper,
  hideTicks,
  align,
  noLabel,
  fontSize = 27,
  lineHeight = 32,
  searchSessionId,
  onLoad
}) {
  var _Object$entries$, _spaceId$space;
  const LensComponent = lens === null || lens === void 0 ? void 0 : lens.EmbeddableComponent;
  const LensSaveModalComponent = lens === null || lens === void 0 ? void 0 : lens.SaveModalComponent;
  const [isSaveOpen, setIsSaveOpen] = (0, _react.useState)(false);
  const [isAddToCaseOpen, setAddToCaseOpen] = (0, _react.useState)(false);
  const spaceId = (0, _use_kibana_space.useKibanaSpace)();
  const series = (_Object$entries$ = Object.entries(attributes)[0]) === null || _Object$entries$ === void 0 ? void 0 : _Object$entries$[1];
  const [operationType, setOperationType] = (0, _react.useState)(series === null || series === void 0 ? void 0 : series.operationType);
  const theme = (0, _use_theme.useTheme)();
  const layerConfigs = (0, _use_lens_attributes.getLayerConfigs)(attributes, reportType, theme, dataViewState, {
    ...reportConfigMap,
    ..._obsv_exploratory_view.obsvReportConfigMap
  }, (_spaceId$space = spaceId.space) === null || _spaceId$space === void 0 ? void 0 : _spaceId$space.id);
  let lensAttributes;
  let attributesJSON = customLensAttrs;
  if (!customLensAttrs) {
    try {
      if (reportType === _.ReportTypes.SINGLE_METRIC) {
        var _lensAttributes;
        lensAttributes = new _single_metric_attributes.SingleMetricLensAttributes(layerConfigs, reportType, lensFormulaHelper);
        attributesJSON = (_lensAttributes = lensAttributes) === null || _lensAttributes === void 0 ? void 0 : _lensAttributes.getJSON('lnsLegacyMetric');
      } else if (reportType === _.ReportTypes.HEATMAP) {
        var _lensAttributes2;
        lensAttributes = new _heatmap_attributes.HeatMapLensAttributes(layerConfigs, reportType, lensFormulaHelper);
        attributesJSON = (_lensAttributes2 = lensAttributes) === null || _lensAttributes2 === void 0 ? void 0 : _lensAttributes2.getJSON('lnsHeatmap');
      } else {
        var _lensAttributes3;
        lensAttributes = new _lens_attributes.LensAttributes(layerConfigs, reportType, lensFormulaHelper);
        attributesJSON = (_lensAttributes3 = lensAttributes) === null || _lensAttributes3 === void 0 ? void 0 : _lensAttributes3.getJSON();
      }
      // eslint-disable-next-line no-empty
    } catch (error) {}
  }
  const timeRange = customTimeRange !== null && customTimeRange !== void 0 ? customTimeRange : series === null || series === void 0 ? void 0 : series.time;
  const actions = (0, _use_actions.useActions)({
    withActions,
    attributes,
    reportType,
    appId,
    setIsSaveOpen,
    setAddToCaseOpen,
    lensAttributes: attributesJSON,
    timeRange
  });
  if (!attributesJSON) {
    return null;
  }
  if (typeof axisTitlesVisibility !== 'undefined') {
    attributesJSON.state.visualization.axisTitlesVisibilitySettings = axisTitlesVisibility;
  }
  if (typeof gridlinesVisibilitySettings !== 'undefined') {
    attributesJSON.state.visualization.gridlinesVisibilitySettings = gridlinesVisibilitySettings;
  }
  if (typeof legendIsVisible !== 'undefined') {
    attributesJSON.state.visualization.legend.isVisible = legendIsVisible;
  }
  if (typeof legendPosition !== 'undefined') {
    attributesJSON.state.visualization.legend.position = legendPosition;
  }
  if (hideTicks) {
    attributesJSON.state.visualization.tickLabelsVisibilitySettings = {
      x: false,
      yRight: false,
      yLeft: false
    };
  }
  if (!attributesJSON && layerConfigs.length < 1) {
    return null;
  }
  if (!LensComponent) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, "No lens component");
  }
  attributesJSON.state.searchSessionId = searchSessionId;
  attributesJSON.searchSessionId = searchSessionId;
  return /*#__PURE__*/_react.default.createElement(Wrapper, {
    $customHeight: customHeight,
    align: align,
    noLabel: noLabel,
    fontSize: fontSize,
    lineHeight: lineHeight
  }, (title || showCalculationMethod || appendTitle) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none"
  }, title && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "exploratoryView-title"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, title))), showCalculationMethod && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      minWidth: 150
    }
  }, /*#__PURE__*/_react.default.createElement(_operation_type_select.OperationTypeComponent, {
    operationType: operationType,
    onChange: val => {
      setOperationType(val);
    }
  })), appendTitle && appendTitle), /*#__PURE__*/_react.default.createElement(LensComponent, {
    id: "exploratoryView",
    "data-test-subj": "exploratoryView",
    style: {
      height: '100%'
    },
    timeRange: timeRange,
    attributes: {
      ...attributesJSON,
      title: undefined,
      hidePanelTitles: true,
      description: ''
    },
    onBrushEnd: onBrushEnd,
    withDefaultActions: Boolean(withActions),
    extraActions: actions,
    viewMode: _common.ViewMode.VIEW,
    searchSessionId: searchSessionId,
    onLoad: onLoad
  }), isSaveOpen && attributesJSON && /*#__PURE__*/_react.default.createElement(LensSaveModalComponent, {
    initialInput: attributesJSON,
    onClose: () => setIsSaveOpen(false)
    // if we want to do anything after the viz is saved
    // right now there is no action, so an empty function
    ,
    onSave: () => {}
  }), /*#__PURE__*/_react.default.createElement(_add_to_case_action.AddToCaseAction, {
    lensAttributes: attributesJSON,
    timeRange: customTimeRange !== null && customTimeRange !== void 0 ? customTimeRange : series === null || series === void 0 ? void 0 : series.time,
    autoOpen: isAddToCaseOpen,
    setAutoOpen: setAddToCaseOpen,
    appId: appId,
    owner: caseOwner
  }));
}
const Wrapper = _styledComponents.default.div`
  height: ${props => props.$customHeight ? `${props.$customHeight};` : `100%;`};
  position: relative;
  &&& {
    > :nth-child(2) {
      height: ${props => props.$customHeight ? `${props.$customHeight};` : `calc(100% - 32px);`};
    }
    .expExpressionRenderer__expression {
      padding: 0 !important;
    }

    .legacyMtrVis {
      > :first-child {
        justify-content: ${props => props.align === 'left' ? `flex-start;` : props.align === 'right' ? `flex-end;` : 'center;'};
      }
      justify-content: flex-end;
      .legacyMtrVis__container {
        padding: 0;
        > :nth-child(2) {
          ${({
  noLabel
}) => noLabel && ` display: none;
        `}
        }
      }
      .legacyMtrVis__value {
        line-height: ${({
  lineHeight
}) => lineHeight}px !important;
        font-size: ${({
  fontSize
}) => fontSize}px !important;
      }
      > :first-child {
        transform: none !important;
      }
    }

    .euiLoadingChart {
      position: absolute;
      top: 50%;
      right: 50%;
      transform: translate(50%, -50%);
    }
  }
`;
module.exports = exports.default;