"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.syntheticsRuntimeFields = void 0;
var _field_formats = require("./field_formats");
var _synthetics = require("../constants/field_names/synthetics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LONG_FIELD = {
  type: 'long',
  format: {
    id: 'duration',
    params: _field_formats.MS_TO_HUMANIZE_PRECISE
  }
};
const syntheticsRuntimeFields = [{
  name: _synthetics.SYNTHETICS_DNS_TIMINGS,
  field: LONG_FIELD
}, {
  name: _synthetics.SYNTHETICS_BLOCKED_TIMINGS,
  field: LONG_FIELD
}, {
  name: _synthetics.SYNTHETICS_CONNECT_TIMINGS,
  field: LONG_FIELD
}, {
  name: _synthetics.SYNTHETICS_TOTAL_TIMINGS,
  field: LONG_FIELD
}, {
  name: _synthetics.SYNTHETICS_RECEIVE_TIMINGS,
  field: LONG_FIELD
}, {
  name: _synthetics.SYNTHETICS_SEND_TIMINGS,
  field: LONG_FIELD
}, {
  name: _synthetics.SYNTHETICS_WAIT_TIMINGS,
  field: LONG_FIELD
}, {
  name: _synthetics.SYNTHETICS_SSL_TIMINGS,
  field: LONG_FIELD
}];
exports.syntheticsRuntimeFields = syntheticsRuntimeFields;