"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.I18LABELS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const I18LABELS = {
  filterByUrl: _i18n.i18n.translate('xpack.exploratoryView.filters.filterByUrl', {
    defaultMessage: 'Filter by URL'
  }),
  getSearchResultsLabel: total => _i18n.i18n.translate('xpack.exploratoryView.filters.searchResults', {
    defaultMessage: '{total} Search results',
    values: {
      total
    }
  }),
  topPages: _i18n.i18n.translate('xpack.exploratoryView.filters.topPages', {
    defaultMessage: 'Top pages'
  }),
  select: _i18n.i18n.translate('xpack.exploratoryView.filters.select', {
    defaultMessage: 'Select'
  }),
  url: _i18n.i18n.translate('xpack.exploratoryView.filters.url', {
    defaultMessage: 'Url'
  }),
  loadingResults: _i18n.i18n.translate('xpack.exploratoryView.filters.url.loadingResults', {
    defaultMessage: 'Loading results'
  }),
  noResults: _i18n.i18n.translate('xpack.exploratoryView.filters.url.noResults', {
    defaultMessage: 'No results available'
  })
};
exports.I18LABELS = I18LABELS;