"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeriesDatePicker = SeriesDatePicker;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_has_data = require("../../../../../hooks/use_has_data");
var _use_series_storage = require("../../hooks/use_series_storage");
var _use_quick_time_ranges = require("../../../../../hooks/use_quick_time_ranges");
var _constants = require("../../configurations/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SeriesDatePicker({
  series,
  seriesId
}) {
  var _series$time, _series$time2;
  const {
    onRefreshTimeRange
  } = (0, _use_has_data.useHasData)();
  const commonlyUsedRanges = (0, _use_quick_time_ranges.useQuickTimeRanges)();
  const {
    setSeries,
    reportType,
    allSeries
  } = (0, _use_series_storage.useSeriesStorage)();
  function onTimeChange({
    start,
    end
  }) {
    onRefreshTimeRange === null || onRefreshTimeRange === void 0 ? void 0 : onRefreshTimeRange();
    if (reportType === _constants.ReportTypes.KPI) {
      allSeries.forEach((currSeries, seriesIndex) => {
        setSeries(seriesIndex, {
          ...currSeries,
          time: {
            from: start,
            to: end
          }
        });
      });
    } else {
      setSeries(seriesId, {
        ...series,
        time: {
          from: start,
          to: end
        }
      });
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    start: series === null || series === void 0 ? void 0 : (_series$time = series.time) === null || _series$time === void 0 ? void 0 : _series$time.from,
    end: series === null || series === void 0 ? void 0 : (_series$time2 = series.time) === null || _series$time2 === void 0 ? void 0 : _series$time2.to,
    onTimeChange: onTimeChange,
    commonlyUsedRanges: commonlyUsedRanges,
    onRefresh: onTimeChange,
    showUpdateButton: false
  });
}