"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeriesColorPicker = SeriesColorPicker;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_theme = require("../../../../hooks/use_theme");
var _use_series_storage = require("../hooks/use_series_storage");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SeriesColorPicker({
  seriesId,
  series
}) {
  var _series$color;
  const theme = (0, _use_theme.useTheme)();
  const {
    setSeries
  } = (0, _use_series_storage.useSeriesStorage)();
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const onChange = colorN => {
    setSeries(seriesId, {
      ...series,
      color: colorN
    });
  };
  const color = (_series$color = series.color) !== null && _series$color !== void 0 ? _series$color : theme.eui[`euiColorVis${seriesId}`];
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: EDIT_SERIES_COLOR_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "o11ySeriesColorPickerButton",
    size: "s",
    onClick: () => setIsOpen(prevState => !prevState),
    flush: "both"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "stopFilled",
    size: "l",
    color: color
  })));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isOpen,
    closePopover: () => setIsOpen(false)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: PICK_A_COLOR_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
    onChange: onChange,
    color: color
  })));
}
const PICK_A_COLOR_LABEL = _i18n.i18n.translate('xpack.exploratoryView.pickColor', {
  defaultMessage: 'Pick a color'
});
const EDIT_SERIES_COLOR_LABEL = _i18n.i18n.translate('xpack.exploratoryView.editSeriesColor', {
  defaultMessage: 'Edit color for series'
});