"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpViewActionMenuContent = ExpViewActionMenuContent;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _embed_action = require("../../header/embed_action");
var _add_to_case_action = require("../../header/add_to_case_action");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ExpViewActionMenuContent({
  timeRange,
  lensAttributes
}) {
  const kServices = (0, _public.useKibana)().services;
  const {
    lens,
    isDev
  } = kServices;
  const [isSaveOpen, setIsSaveOpen] = (0, _react.useState)(false);
  const LensSaveModalComponent = lens.SaveModalComponent;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    style: {
      paddingRight: 20
    }
  }, isDev && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_embed_action.EmbedAction, {
    lensAttributes: lensAttributes
  })), timeRange && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_add_to_case_action.AddToCaseAction, {
    lensAttributes: lensAttributes,
    timeRange: timeRange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "o11yExpViewActionMenuContentOpenInLensButton",
    iconType: "lensApp",
    fullWidth: false,
    isDisabled: !lens.canUseEditor() || lensAttributes === null,
    size: "s",
    onClick: () => {
      if (lensAttributes) {
        lens.navigateToPrefilledEditor({
          id: '',
          timeRange,
          attributes: lensAttributes
        }, {
          openInNewTab: true
        });
      }
    }
  }, _i18n.i18n.translate('xpack.exploratoryView.expView.heading.openInLens', {
    defaultMessage: 'Open in Lens'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "o11yExpViewActionMenuContentSaveButton",
    fill: true,
    iconType: "save",
    fullWidth: false,
    isDisabled: !lens.canUseEditor() || lensAttributes === null,
    onClick: () => {
      if (lensAttributes) {
        setIsSaveOpen(true);
      }
    },
    size: "s"
  }, _i18n.i18n.translate('xpack.exploratoryView.expView.heading.saveLensVisualization', {
    defaultMessage: 'Save'
  })))), isSaveOpen && lensAttributes && /*#__PURE__*/_react.default.createElement(LensSaveModalComponent, {
    initialInput: lensAttributes,
    onClose: () => setIsSaveOpen(false)
    // if we want to do anything after the viz is saved
    // right now there is no action, so an empty function
    ,
    onSave: () => {}
  }));
}