"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventAnnotationPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _event_annotation_service = require("./event_annotation_service");
var _common = require("../common");
var _fetch_event_annotations = require("./fetch_event_annotations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @public */
class EventAnnotationPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "eventAnnotationService", new _event_annotation_service.EventAnnotationService());
  }
  setup(core, dependencies) {
    dependencies.expressions.registerFunction(_common.manualPointEventAnnotation);
    dependencies.expressions.registerFunction(_common.manualRangeEventAnnotation);
    dependencies.expressions.registerFunction(_common.queryPointEventAnnotation);
    dependencies.expressions.registerFunction(_common.eventAnnotationGroup);
    dependencies.expressions.registerFunction((0, _fetch_event_annotations.getFetchEventAnnotations)({
      getStartServices: core.getStartServices
    }));
    return this.eventAnnotationService;
  }
  start(core, startDependencies) {
    return this.eventAnnotationService;
  }
}
exports.EventAnnotationPlugin = EventAnnotationPlugin;