"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isRangeAnnotationConfig = exports.isQueryAnnotationConfig = exports.isManualPointAnnotationConfig = exports.defaultAnnotationRangeColor = exports.defaultAnnotationLabel = exports.defaultAnnotationColor = void 0;
var _i18n = require("@kbn/i18n");
var _uiTheme = require("@kbn/ui-theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const defaultAnnotationColor = _uiTheme.euiLightVars.euiColorAccent;
// Do not compute it live as dependencies will add tens of Kbs to the plugin
exports.defaultAnnotationColor = defaultAnnotationColor;
const defaultAnnotationRangeColor = `#F04E981A`; // defaultAnnotationColor with opacity 0.1
exports.defaultAnnotationRangeColor = defaultAnnotationRangeColor;
const defaultAnnotationLabel = _i18n.i18n.translate('eventAnnotation.manualAnnotation.defaultAnnotationLabel', {
  defaultMessage: 'Event'
});
exports.defaultAnnotationLabel = defaultAnnotationLabel;
const isRangeAnnotationConfig = annotation => {
  return Boolean(annotation && (annotation === null || annotation === void 0 ? void 0 : annotation.key.type) === 'range');
};
exports.isRangeAnnotationConfig = isRangeAnnotationConfig;
const isManualPointAnnotationConfig = annotation => {
  return Boolean(annotation && 'timestamp' in (annotation === null || annotation === void 0 ? void 0 : annotation.key));
};
exports.isManualPointAnnotationConfig = isManualPointAnnotationConfig;
const isQueryAnnotationConfig = annotation => {
  return Boolean(annotation && annotation.type === 'query');
};
exports.isQueryAnnotationConfig = isQueryAnnotationConfig;