"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewApiRequestFlyout = exports.ApiRequestFlyout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _lzString = require("lz-string");
var _eui = require("@elastic/eui");
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ApiRequestFlyout = ({
  title,
  description,
  request,
  closeFlyout,
  flyoutProps,
  urlService,
  application
}) => {
  var _application$capabili, _application$capabili2, _urlService$locators$;
  const getUrlParams = undefined;
  const canShowDevtools = !!(application !== null && application !== void 0 && (_application$capabili = application.capabilities) !== null && _application$capabili !== void 0 && (_application$capabili2 = _application$capabili.dev_tools) !== null && _application$capabili2 !== void 0 && _application$capabili2.show);
  const devToolsDataUri = (0, _lzString.compressToEncodedURIComponent)(request);

  // Generate a console preview link if we have a valid locator
  const consolePreviewLink = urlService === null || urlService === void 0 ? void 0 : (_urlService$locators$ = urlService.locators.get('CONSOLE_APP_LOCATOR')) === null || _urlService$locators$ === void 0 ? void 0 : _urlService$locators$.useUrl({
    loadFrom: `data:text/plain,${devToolsDataUri}`
  }, getUrlParams, [request]);

  // Check if both the Dev Tools UI and the Console UI are enabled.
  const shouldShowDevToolsLink = canShowDevtools && consolePreviewLink !== undefined;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, (0, _extends2.default)({
    onClose: closeFlyout,
    "data-test-subj": "apiRequestFlyout"
  }, flyoutProps), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "apiRequestFlyoutTitle"
  }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "apiRequestFlyoutDescription"
  }, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-textRight"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: request
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    flush: "right",
    iconType: "copyClipboard",
    onClick: copy,
    "data-test-subj": "apiRequestFlyoutCopyClipboardButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "esUi.viewApiRequest.copyToClipboardButton",
    defaultMessage: "Copy to clipboard"
  }))), shouldShowDevToolsLink && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    flush: "right",
    iconType: "wrench",
    href: consolePreviewLink,
    "data-test-subj": "apiRequestFlyoutOpenInConsoleButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "esUi.viewApiRequest.openInConsoleButton",
    defaultMessage: "Open in Console"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    "data-test-subj": "apiRequestFlyoutBody"
  }, request)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: closeFlyout,
    flush: "left",
    "data-test-subj": "apiRequestFlyoutClose"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "esUi.viewApiRequest.closeButtonLabel",
    defaultMessage: "Close"
  }))));
};
exports.ApiRequestFlyout = ApiRequestFlyout;
const ViewApiRequestFlyout = props => {
  if (props.application) {
    return /*#__PURE__*/_react.default.createElement(_public2.RedirectAppLinks, {
      application: props.application,
      className: _public.APP_WRAPPER_CLASS,
      "data-test-subj": "apiRequestFlyoutRedirectWrapper"
    }, /*#__PURE__*/_react.default.createElement(ApiRequestFlyout, props));
  }
  return /*#__PURE__*/_react.default.createElement(ApiRequestFlyout, props);
};
exports.ViewApiRequestFlyout = ViewApiRequestFlyout;