"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isQueryStringFilter = exports.buildQueryFilter = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * @param filter
 * @returns `true` if a filter is a `QueryStringFilter`
 *
 * @public
 */
const isQueryStringFilter = filter => (0, _lodash.has)(filter, 'query.query_string');

/**
 * Creates a filter corresponding to a raw Elasticsearch query DSL object
 * @param query
 * @param index
 * @param alias
 * @returns `QueryStringFilter`
 *
 * @public
 */
exports.isQueryStringFilter = isQueryStringFilter;
const buildQueryFilter = (query, index, alias, meta = {}) => ({
  query,
  meta: {
    index,
    alias,
    ...meta
  }
});
exports.buildQueryFilter = buildQueryFilter;