"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrateFilter = migrateFilter;
var _lodash = require("lodash");
var _filters = require("../filters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function isDeprecatedMatchPhraseFilter(filter) {
  var _ref, _filter$query;
  // @ts-ignore
  const fieldName = Object.keys((_ref = filter.match || ((_filter$query = filter.query) === null || _filter$query === void 0 ? void 0 : _filter$query.match)) !== null && _ref !== void 0 ? _ref : {})[0];
  return Boolean(fieldName && ((0, _lodash.get)(filter, ['query', 'match', fieldName, 'type']) === 'phrase' || (0, _lodash.get)(filter, ['match', fieldName, 'type']) === 'phrase'));
}

/** @internal */
function migrateFilter(filter, indexPattern) {
  if (isDeprecatedMatchPhraseFilter(filter)) {
    // @ts-ignore
    const match = filter.match || filter.query.match;
    const fieldName = Object.keys(match)[0];
    const params = (0, _lodash.get)(match, [fieldName]);
    let query = params.query;
    if (indexPattern) {
      const field = indexPattern.fields.find(f => f.name === fieldName);
      if (field) {
        query = (0, _filters.getConvertedValueForField)(field, params.query);
      }
    }
    return {
      meta: filter.meta,
      $state: filter.$state,
      query: {
        match_phrase: {
          [fieldName]: (0, _lodash.omit)({
            ...params,
            query
          }, 'type')
        }
      }
    };
  }
  if (!filter.query) {
    filter = {
      ...filter,
      query: {}
    };
  } else {
    // handle the case where .query already exists and filter has other top level keys on there
    filter = (0, _lodash.pick)(filter, ['meta', 'query', '$state']);
  }

  // @ts-ignore
  if (filter.exists) {
    // @ts-ignore
    filter.query.exists = filter.exists;
    // @ts-ignore
    delete filter.exists;
  }

  // @ts-ignore
  if (filter.range) {
    // @ts-ignore
    filter.query.range = filter.range;
    // @ts-ignore
    delete filter.range;
  }

  // @ts-ignore
  if (filter.match_all) {
    // @ts-ignore
    filter.query.match_all = filter.match_all;
    // @ts-ignore
    delete filter.match_all;
  }

  // move all other keys under query
  Object.keys(filter).forEach(key => {
    if (key === 'meta' || key === 'query' || key === '$state') {
      return;
    }
    // @ts-ignore
    filter.query[key] = filter[key];
    // @ts-ignore
    delete filter[key];
  });
  return filter;
}