"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createConnectorDocument = createConnectorDocument;
var _native_connectors = require("../../common/connectors/native_connectors");
var _constants = require("../../common/constants");
var _connectors = require("../../common/types/connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createConnectorDocument({
  indexName,
  isNative,
  pipeline,
  serviceType,
  language
}) {
  const currentTimestamp = new Date().toISOString();
  const nativeConnector = isNative && serviceType ? _native_connectors.NATIVE_CONNECTOR_DEFINITIONS[serviceType] : undefined;
  if (isNative && serviceType && !nativeConnector && serviceType !== _constants.ENTERPRISE_SEARCH_CONNECTOR_CRAWLER_SERVICE_TYPE) {
    throw new Error(`Could not find connector definition for service type ${serviceType}`);
  }
  const nativeFields = nativeConnector ? {
    configuration: nativeConnector.configuration,
    features: nativeConnector.features,
    name: nativeConnector.name,
    service_type: serviceType,
    status: _connectors.ConnectorStatus.NEEDS_CONFIGURATION
  } : {};
  return {
    api_key_id: null,
    configuration: {},
    custom_scheduling: {},
    description: null,
    error: null,
    features: null,
    filtering: [{
      active: {
        advanced_snippet: {
          created_at: currentTimestamp,
          updated_at: currentTimestamp,
          value: {}
        },
        rules: [{
          created_at: currentTimestamp,
          field: '_',
          id: 'DEFAULT',
          order: 0,
          policy: _connectors.FilteringPolicy.INCLUDE,
          rule: _connectors.FilteringRuleRule.REGEX,
          updated_at: currentTimestamp,
          value: '.*'
        }],
        validation: {
          errors: [],
          state: _connectors.FilteringValidationState.VALID
        }
      },
      domain: 'DEFAULT',
      draft: {
        advanced_snippet: {
          created_at: currentTimestamp,
          updated_at: currentTimestamp,
          value: {}
        },
        rules: [{
          created_at: currentTimestamp,
          field: '_',
          id: 'DEFAULT',
          order: 0,
          policy: _connectors.FilteringPolicy.INCLUDE,
          rule: _connectors.FilteringRuleRule.REGEX,
          updated_at: currentTimestamp,
          value: '.*'
        }],
        validation: {
          errors: [],
          state: _connectors.FilteringValidationState.VALID
        }
      }
    }],
    index_name: indexName,
    is_native: isNative,
    language,
    last_seen: null,
    last_sync_error: null,
    last_sync_scheduled_at: null,
    last_sync_status: null,
    last_synced: null,
    name: indexName.startsWith('search-') ? indexName.substring(7) : indexName,
    pipeline,
    scheduling: {
      enabled: false,
      interval: '0 0 0 * * ?'
    },
    service_type: serviceType || null,
    status: _connectors.ConnectorStatus.CREATED,
    sync_now: false,
    ...nativeFields
  };
}