"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchIndicesStats = void 0;
var _available_indices = require("./available_indices");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchIndicesStats = async (client, indices) => {
  const indicesStats = await client.asCurrentUser.indices.stats({
    index: await (0, _available_indices.availableIndices)(client, indices),
    metric: ['docs']
  });
  return indices.map(index => {
    var _indicesStats$indices, _indexStats$primaries, _indexStats$primaries2, _indexStats$primaries3, _indexStats$health;
    const indexStats = (_indicesStats$indices = indicesStats.indices) === null || _indicesStats$indices === void 0 ? void 0 : _indicesStats$indices[index];
    return {
      count: (_indexStats$primaries = indexStats === null || indexStats === void 0 ? void 0 : (_indexStats$primaries2 = indexStats.primaries) === null || _indexStats$primaries2 === void 0 ? void 0 : (_indexStats$primaries3 = _indexStats$primaries2.docs) === null || _indexStats$primaries3 === void 0 ? void 0 : _indexStats$primaries3.count) !== null && _indexStats$primaries !== void 0 ? _indexStats$primaries : null,
      health: (_indexStats$health = indexStats === null || indexStats === void 0 ? void 0 : indexStats.health) !== null && _indexStats$health !== void 0 ? _indexStats$health : 'unknown',
      name: index
    };
  });
};
exports.fetchIndicesStats = fetchIndicesStats;