"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateConnectorConfiguration = void 0;
var _i18n = require("@kbn/i18n");
var _ = require("../..");
var _connectors = require("../../../common/types/connectors");
var _is_not_nullish = require("../../../common/utils/is_not_nullish");
var _fetch_connectors = require("./fetch_connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateConnectorConfiguration = async (client, connectorId, configuration) => {
  const connectorResult = await (0, _fetch_connectors.fetchConnectorById)(client, connectorId);
  const connector = connectorResult === null || connectorResult === void 0 ? void 0 : connectorResult.value;
  if (connector) {
    const status = connector.status === _connectors.ConnectorStatus.NEEDS_CONFIGURATION ? _connectors.ConnectorStatus.CONFIGURED : connector.status;
    const updatedConfig = Object.keys(connector.configuration).map(key => {
      var _ref, _configuration$key, _connector$configurat;
      return connector.configuration[key] ? {
        ...connector.configuration[key],
        // ugly but needed because typescript refuses to believe this is defined
        key,
        value: (_ref = (_configuration$key = configuration[key]) !== null && _configuration$key !== void 0 ? _configuration$key : (_connector$configurat = connector.configuration[key]) === null || _connector$configurat === void 0 ? void 0 : _connector$configurat.value) !== null && _ref !== void 0 ? _ref : ''
      } : undefined;
    }).filter(_is_not_nullish.isNotNullish).reduce((prev, curr) => {
      const {
        key,
        ...config
      } = curr;
      return {
        ...prev,
        [curr.key]: config
      };
    }, {});
    await client.asCurrentUser.update({
      doc: {
        configuration: updatedConfig,
        status
      },
      id: connectorId,
      if_primary_term: connectorResult === null || connectorResult === void 0 ? void 0 : connectorResult.primaryTerm,
      if_seq_no: connectorResult === null || connectorResult === void 0 ? void 0 : connectorResult.seqNo,
      index: _.CONNECTORS_INDEX,
      refresh: 'wait_for'
    });
    return updatedConfig;
  } else {
    throw new Error(_i18n.i18n.translate('xpack.enterpriseSearch.server.connectors.configuration.error', {
      defaultMessage: 'Could not find connector'
    }));
  }
};
exports.updateConnectorConfiguration = updateConnectorConfiguration;