"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchSyncJobsByConnectorId = void 0;
var _ = require("../..");
var _is_not_nullish = require("../../../common/utils/is_not_nullish");
var _setup_indices = require("../../index_management/setup_indices");
var _fetch_with_pagination = require("../../utils/fetch_with_pagination");
var _identify_exceptions = require("../../utils/identify_exceptions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultResult = {
  _meta: {
    page: {
      from: 0,
      has_more_hits_than_total: false,
      size: 10,
      total: 0
    }
  },
  data: []
};
const fetchSyncJobsByConnectorId = async (client, connectorId, from, size) => {
  try {
    const result = await (0, _fetch_with_pagination.fetchWithPagination)(async () => await client.asCurrentUser.search({
      from,
      index: _.CONNECTORS_JOBS_INDEX,
      query: {
        term: {
          'connector.id': connectorId
        }
      },
      size,
      sort: {
        created_at: {
          order: 'desc'
        }
      }
    }), from, size);
    return {
      ...result,
      data: result.data.map(hit => hit._source ? {
        ...hit._source,
        id: hit._id
      } : null).filter(_is_not_nullish.isNotNullish)
    };
  } catch (error) {
    if ((0, _identify_exceptions.isIndexNotFoundException)(error)) {
      await (0, _setup_indices.setupConnectorsIndices)(client.asCurrentUser);
      return defaultResult;
    } else {
      throw error;
    }
  }
};
exports.fetchSyncJobsByConnectorId = fetchSyncJobsByConnectorId;