"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchConnectorIndexNames = fetchConnectorIndexNames;
var _ = require("../..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function fetchConnectorIndexNames(client) {
  var _result$hits$hits;
  const result = await client.asCurrentUser.search({
    _source: false,
    fields: [{
      field: 'index_name'
    }],
    index: _.CONNECTORS_INDEX,
    size: 10000
  });
  return ((_result$hits$hits = result === null || result === void 0 ? void 0 : result.hits.hits) !== null && _result$hits$hits !== void 0 ? _result$hits$hits : []).map(field => {
    var _field$fields$index_n, _field$fields;
    return (_field$fields$index_n = (_field$fields = field.fields) === null || _field$fields === void 0 ? void 0 : _field$fields.index_name[0]) !== null && _field$fields$index_n !== void 0 ? _field$fields$index_n : '';
  });
}