"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteConnectorById = void 0;
var _ = require("../..");
var _post_cancel_syncs = require("./post_cancel_syncs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteConnectorById = async (client, id) => {
  // timeout function to mitigate race condition with external connector running job and recreating index
  const timeout = async () => {
    const promise = new Promise(resolve => setTimeout(resolve, 500));
    return promise;
  };
  await Promise.all([(0, _post_cancel_syncs.cancelSyncs)(client, id), timeout]);
  return await client.asCurrentUser.delete({
    id,
    index: _.CONNECTORS_INDEX,
    refresh: 'wait_for'
  });
};
exports.deleteConnectorById = deleteConnectorById;