"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addConnector = void 0;
var _ = require("../..");
var _error_codes = require("../../../common/types/error_codes");
var _setup_indices = require("../../index_management/setup_indices");
var _create_connector_document = require("../../utils/create_connector_document");
var _fetch_crawlers = require("../crawler/fetch_crawlers");
var _create_index = require("../indices/create_index");
var _delete_connector = require("./delete_connector");
var _fetch_connectors = require("./fetch_connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createConnector = async (document, client, language, deleteExisting) => {
  const index = document.index_name;
  const indexExists = await client.asCurrentUser.indices.exists({
    index
  });
  if (indexExists) {
    {
      throw new Error(_error_codes.ErrorCode.INDEX_ALREADY_EXISTS);
    }
  }
  const connector = await (0, _fetch_connectors.fetchConnectorByIndexName)(client, index);
  if (connector) {
    if (deleteExisting) {
      await (0, _delete_connector.deleteConnectorById)(client, connector.id);
    } else {
      throw new Error(_error_codes.ErrorCode.CONNECTOR_DOCUMENT_ALREADY_EXISTS);
    }
  }
  const crawler = await (0, _fetch_crawlers.fetchCrawlerByIndexName)(client, index);
  if (crawler) {
    throw new Error(_error_codes.ErrorCode.CRAWLER_ALREADY_EXISTS);
  }
  const result = await client.asCurrentUser.index({
    document,
    index: _.CONNECTORS_INDEX,
    refresh: true
  });
  await (0, _create_index.createIndex)(client, document.index_name, language, false);
  return {
    id: result._id,
    index_name: document.index_name
  };
};
const addConnector = async (client, input) => {
  var _connectorsIndicesMap, _connectorsIndicesMap2, _connectorsIndicesMap3, _input$service_type;
  const connectorsIndexExists = await client.asCurrentUser.indices.exists({
    index: _.CONNECTORS_INDEX
  });
  if (!connectorsIndexExists) {
    await (0, _setup_indices.setupConnectorsIndices)(client.asCurrentUser);
  }
  const connectorsIndicesMapping = await client.asCurrentUser.indices.getMapping({
    index: _.CONNECTORS_INDEX
  });
  const pipeline = (_connectorsIndicesMap = connectorsIndicesMapping[`${_.CONNECTORS_INDEX}-v${_.CONNECTORS_VERSION}`]) === null || _connectorsIndicesMap === void 0 ? void 0 : (_connectorsIndicesMap2 = _connectorsIndicesMap.mappings) === null || _connectorsIndicesMap2 === void 0 ? void 0 : (_connectorsIndicesMap3 = _connectorsIndicesMap2._meta) === null || _connectorsIndicesMap3 === void 0 ? void 0 : _connectorsIndicesMap3.pipeline;
  const document = (0, _create_connector_document.createConnectorDocument)({
    indexName: input.index_name,
    isNative: input.is_native,
    language: input.language,
    pipeline: pipeline ? {
      extract_binary_content: pipeline.default_extract_binary_content,
      name: pipeline.default_name,
      reduce_whitespace: pipeline.default_reduce_whitespace,
      run_ml_inference: pipeline.default_run_ml_inference
    } : null,
    serviceType: (_input$service_type = input.service_type) !== null && _input$service_type !== void 0 ? _input$service_type : null
  });
  return await createConnector(document, client, input.language, !!input.delete_existing_connector);
};
exports.addConnector = addConnector;