"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchAnalyticsCollections = void 0;
var _error_codes = require("../../../common/types/error_codes");
var _identify_exceptions = require("../../utils/identify_exceptions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchAnalyticsCollections = async (client, query = '') => {
  try {
    const collections = await client.asCurrentUser.transport.request({
      method: 'GET',
      path: `/_application/analytics/${query}`
    });
    return Object.keys(collections).map(value => {
      const entry = collections[value];
      return {
        events_datastream: entry.event_data_stream.name,
        name: value
      };
    });
  } catch (error) {
    if ((0, _identify_exceptions.isResourceNotFoundException)(error)) {
      throw new Error(_error_codes.ErrorCode.ANALYTICS_COLLECTION_NOT_FOUND);
    }
    throw error;
  }
};
exports.fetchAnalyticsCollections = fetchAnalyticsCollections;