"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnterpriseSearchPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/core/public");
var _constants = require("../common/constants");
var _doc_links = require("./applications/shared/doc_links");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class EnterpriseSearchPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "hasInitialized", false);
    (0, _defineProperty2.default)(this, "data", {});
    this.config = initializerContext.config.get();
  }
  setup(core, plugins) {
    const {
      cloud
    } = plugins;
    const {
      config
    } = this;
    core.application.register({
      id: _constants.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.ID,
      title: _constants.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.NAV_TITLE,
      euiIconType: _constants.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.LOGO,
      appRoute: _constants.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.URL,
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      mount: async params => {
        const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
        const {
          chrome,
          http
        } = kibanaDeps.core;
        chrome.docTitle.change(_constants.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.NAME);
        await this.getInitialData(http);
        const pluginData = this.getPluginData();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
        const {
          EnterpriseSearchOverview
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/enterprise_search_overview')));
        return renderApp(EnterpriseSearchOverview, kibanaDeps, pluginData);
      }
    });
    core.application.register({
      id: _constants.ENTERPRISE_SEARCH_CONTENT_PLUGIN.ID,
      title: _constants.ENTERPRISE_SEARCH_CONTENT_PLUGIN.NAV_TITLE,
      euiIconType: _constants.ENTERPRISE_SEARCH_CONTENT_PLUGIN.LOGO,
      appRoute: _constants.ENTERPRISE_SEARCH_CONTENT_PLUGIN.URL,
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      mount: async params => {
        const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
        const {
          chrome,
          http
        } = kibanaDeps.core;
        chrome.docTitle.change(_constants.ENTERPRISE_SEARCH_CONTENT_PLUGIN.NAME);
        await this.getInitialData(http);
        const pluginData = this.getPluginData();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
        const {
          EnterpriseSearchContent
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/enterprise_search_content')));
        return renderApp(EnterpriseSearchContent, kibanaDeps, pluginData);
      }
    });
    core.application.register({
      appRoute: _constants.APPLICATIONS_PLUGIN.URL,
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      euiIconType: _constants.APPLICATIONS_PLUGIN.LOGO,
      id: _constants.APPLICATIONS_PLUGIN.ID,
      navLinkStatus: _public.AppNavLinkStatus.default,
      searchable: true,
      title: _constants.APPLICATIONS_PLUGIN.NAV_TITLE,
      mount: async params => {
        const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
        const {
          chrome,
          http
        } = kibanaDeps.core;
        chrome.docTitle.change(_constants.ENTERPRISE_SEARCH_CONTENT_PLUGIN.NAME);
        await this.getInitialData(http);
        const pluginData = this.getPluginData();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
        const {
          Applications
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/applications')));
        return renderApp(Applications, kibanaDeps, pluginData);
      }
    });
    core.application.register({
      id: _constants.ANALYTICS_PLUGIN.ID,
      title: _constants.ANALYTICS_PLUGIN.NAME,
      euiIconType: _constants.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.LOGO,
      searchable: true,
      navLinkStatus: _public.AppNavLinkStatus.default,
      appRoute: _constants.ANALYTICS_PLUGIN.URL,
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      mount: async params => {
        const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
        const {
          chrome,
          http
        } = kibanaDeps.core;
        chrome.docTitle.change(_constants.ANALYTICS_PLUGIN.NAME);
        await this.getInitialData(http);
        const pluginData = this.getPluginData();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
        const {
          Analytics
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/analytics')));
        return renderApp(Analytics, kibanaDeps, pluginData);
      }
    });
    core.application.register({
      id: _constants.ELASTICSEARCH_PLUGIN.ID,
      title: _constants.ELASTICSEARCH_PLUGIN.NAME,
      euiIconType: _constants.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.LOGO,
      appRoute: _constants.ELASTICSEARCH_PLUGIN.URL,
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      mount: async params => {
        const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
        const {
          chrome,
          http
        } = kibanaDeps.core;
        chrome.docTitle.change(_constants.ELASTICSEARCH_PLUGIN.NAME);
        await this.getInitialData(http);
        const pluginData = this.getPluginData();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
        const {
          Elasticsearch
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/elasticsearch')));
        return renderApp(Elasticsearch, kibanaDeps, pluginData);
      }
    });
    if (config.canDeployEntSearch) {
      core.application.register({
        id: _constants.APP_SEARCH_PLUGIN.ID,
        title: _constants.APP_SEARCH_PLUGIN.NAME,
        euiIconType: _constants.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.LOGO,
        appRoute: _constants.APP_SEARCH_PLUGIN.URL,
        category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
        mount: async params => {
          const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
          const {
            chrome,
            http
          } = kibanaDeps.core;
          chrome.docTitle.change(_constants.APP_SEARCH_PLUGIN.NAME);
          await this.getInitialData(http);
          const pluginData = this.getPluginData();
          const {
            renderApp
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
          const {
            AppSearch
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/app_search')));
          return renderApp(AppSearch, kibanaDeps, pluginData);
        }
      });
      core.application.register({
        id: _constants.WORKPLACE_SEARCH_PLUGIN.ID,
        title: _constants.WORKPLACE_SEARCH_PLUGIN.NAME,
        euiIconType: _constants.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.LOGO,
        appRoute: _constants.WORKPLACE_SEARCH_PLUGIN.URL,
        category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
        mount: async params => {
          const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
          const {
            chrome,
            http
          } = kibanaDeps.core;
          chrome.docTitle.change(_constants.WORKPLACE_SEARCH_PLUGIN.NAME);

          // The Workplace Search Personal dashboard needs the chrome hidden. We hide it globally
          // here first to prevent a flash of chrome on the Personal dashboard and unhide it for admin routes.
          if (this.config.host) chrome.setIsVisible(false);
          await this.getInitialData(http);
          const pluginData = this.getPluginData();
          const {
            renderApp
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
          const {
            WorkplaceSearch
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/workplace_search')));
          return renderApp(WorkplaceSearch, kibanaDeps, pluginData);
        }
      });
    }
    core.application.register({
      id: _constants.SEARCH_EXPERIENCES_PLUGIN.ID,
      title: _constants.SEARCH_EXPERIENCES_PLUGIN.NAME,
      euiIconType: _constants.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.LOGO,
      appRoute: _constants.SEARCH_EXPERIENCES_PLUGIN.URL,
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      mount: async params => {
        const kibanaDeps = await this.getKibanaDeps(core, params, cloud);
        const {
          chrome,
          http
        } = kibanaDeps.core;
        chrome.docTitle.change(_constants.SEARCH_EXPERIENCES_PLUGIN.NAME);
        await this.getInitialData(http);
        const pluginData = this.getPluginData();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications')));
        const {
          SearchExperiences
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./applications/search_experiences')));
        return renderApp(SearchExperiences, kibanaDeps, pluginData);
      }
    });
    if (plugins.home) {
      plugins.home.featureCatalogue.registerSolution({
        id: _constants.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.ID,
        title: _constants.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.NAME,
        icon: 'logoEnterpriseSearch',
        description: _constants.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.DESCRIPTION,
        path: _constants.ENTERPRISE_SEARCH_OVERVIEW_PLUGIN.URL,
        order: 100
      });
      plugins.home.featureCatalogue.register({
        id: _constants.ANALYTICS_PLUGIN.ID,
        title: _constants.ANALYTICS_PLUGIN.NAME,
        icon: 'appAnalytics',
        description: _constants.ANALYTICS_PLUGIN.DESCRIPTION,
        path: _constants.ANALYTICS_PLUGIN.URL,
        category: 'data',
        showOnHomePage: false
      });
      if (config.canDeployEntSearch) {
        plugins.home.featureCatalogue.register({
          id: _constants.APP_SEARCH_PLUGIN.ID,
          title: _constants.APP_SEARCH_PLUGIN.NAME,
          icon: 'appSearchApp',
          description: _constants.APP_SEARCH_PLUGIN.DESCRIPTION,
          path: _constants.APP_SEARCH_PLUGIN.URL,
          category: 'data',
          showOnHomePage: false
        });
        plugins.home.featureCatalogue.register({
          id: _constants.WORKPLACE_SEARCH_PLUGIN.ID,
          title: _constants.WORKPLACE_SEARCH_PLUGIN.NAME,
          icon: 'workplaceSearchApp',
          description: _constants.WORKPLACE_SEARCH_PLUGIN.DESCRIPTION,
          path: _constants.WORKPLACE_SEARCH_PLUGIN.URL,
          category: 'data',
          showOnHomePage: false
        });
      }
      plugins.home.featureCatalogue.register({
        id: _constants.ELASTICSEARCH_PLUGIN.ID,
        title: _constants.ELASTICSEARCH_PLUGIN.NAME,
        icon: 'appElasticsearch',
        description: _constants.ELASTICSEARCH_PLUGIN.DESCRIPTION,
        path: _constants.ELASTICSEARCH_PLUGIN.URL,
        category: 'data',
        showOnHomePage: false
      });
      plugins.home.featureCatalogue.register({
        id: _constants.SEARCH_EXPERIENCES_PLUGIN.ID,
        title: _constants.SEARCH_EXPERIENCES_PLUGIN.NAME,
        icon: 'logoEnterpriseSearch',
        description: _constants.SEARCH_EXPERIENCES_PLUGIN.DESCRIPTION,
        path: _constants.SEARCH_EXPERIENCES_PLUGIN.URL,
        category: 'data',
        showOnHomePage: false
      });
    }
  }
  start(core) {
    // This must be called here in start() and not in `applications/index.tsx` to prevent loading
    // race conditions with our apps' `routes.ts` being initialized before `renderApp()`
    _doc_links.docLinks.setDocLinks(core.docLinks);
  }
  stop() {}
  async getKibanaDeps(core, params, cloudSetup) {
    // Helper for using start dependencies on mount (instead of setup dependencies)
    // and for grouping Kibana-related args together (vs. plugin-specific args)
    const [coreStart, pluginsStart] = await core.getStartServices();
    const cloud = cloudSetup && pluginsStart.cloud ? {
      ...cloudSetup,
      ...pluginsStart.cloud
    } : undefined;
    const plugins = {
      ...pluginsStart,
      cloud
    };
    return {
      params,
      core: coreStart,
      plugins
    };
  }
  getPluginData() {
    // Small helper for grouping plugin data related args together
    return {
      config: this.config,
      data: this.data
    };
  }
  async getInitialData(http) {
    if (!this.config.host && this.config.canDeployEntSearch) return; // No API to call
    if (this.hasInitialized) return; // We've already made an initial call

    try {
      this.data = await http.get('/internal/enterprise_search/config_data');
      this.hasInitialized = true;
    } catch (e) {
      this.data.errorConnectingMessage = `${e.response.status} ${e.message}`;
    }
  }
}
exports.EnterpriseSearchPlugin = EnterpriseSearchPlugin;