"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RESET_LOGO_DESCRIPTION = exports.RESET_IMAGE_TITLE = exports.RESET_IMAGE_CONFIRMATION_TEXT = exports.RESET_ICON_DESCRIPTION = exports.ORGANIZATION_LABEL = exports.LOGO_TEXT = exports.LOGO_HELP_TEXT = exports.LOGO_DESCRIPTION = exports.ICON_TEXT = exports.ICON_HELP_TEXT = exports.ICON_DESCRIPTION = exports.BRAND_TEXT = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOGO_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.settings.logoText', {
  defaultMessage: 'logo'
});
exports.LOGO_TEXT = LOGO_TEXT;
const ICON_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.settings.iconText', {
  defaultMessage: 'icon'
});
exports.ICON_TEXT = ICON_TEXT;
const RESET_IMAGE_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.settings.resetImageTitle', {
  defaultMessage: 'Reset to default branding'
});
exports.RESET_IMAGE_TITLE = RESET_IMAGE_TITLE;
const RESET_LOGO_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.settings.resetLogoDescription', {
  defaultMessage: "You're about to reset the logo to the default Workplace Search branding."
});
exports.RESET_LOGO_DESCRIPTION = RESET_LOGO_DESCRIPTION;
const RESET_ICON_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.settings.resetIconDescription', {
  defaultMessage: "You're about to reset the icon to the default Workplace Search branding."
});
exports.RESET_ICON_DESCRIPTION = RESET_ICON_DESCRIPTION;
const RESET_IMAGE_CONFIRMATION_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.settings.resetImageConfirmationText', {
  defaultMessage: 'Are you sure you want to do this?'
});
exports.RESET_IMAGE_CONFIRMATION_TEXT = RESET_IMAGE_CONFIRMATION_TEXT;
const ORGANIZATION_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.settings.organizationLabel', {
  defaultMessage: 'Organization'
});
exports.ORGANIZATION_LABEL = ORGANIZATION_LABEL;
const BRAND_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.settings.brandText', {
  defaultMessage: 'Brand'
});
exports.BRAND_TEXT = BRAND_TEXT;
const LOGO_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.settings.logoDescription', {
  defaultMessage: 'Used as the main visual branding element across prebuilt search applications'
});
exports.LOGO_DESCRIPTION = LOGO_DESCRIPTION;
const LOGO_HELP_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.settings.logoHelpText', {
  defaultMessage: 'Maximum file size is 2MB. Only PNG files are supported.'
});
exports.LOGO_HELP_TEXT = LOGO_HELP_TEXT;
const ICON_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.settings.iconDescription', {
  defaultMessage: 'Used as the branding element for smaller screen sizes and browser icons'
});
exports.ICON_DESCRIPTION = ICON_DESCRIPTION;
const ICON_HELP_TEXT = _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.settings.iconHelpText', {
  defaultMessage: 'Maximum file size is 2MB and recommended aspect ratio is 1:1. Only PNG files are supported.'
});
exports.ICON_HELP_TEXT = ICON_HELP_TEXT;