"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourcesList = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _source_option_item = require("./source_option_item");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SourcesList = ({
  contentSources,
  filteredSources,
  addFilteredSource,
  removeFilteredSource
}) => {
  const sourceIds = contentSources.map(({
    id
  }) => id);
  const sources = sourceIds.map((sourceId, index) => {
    const checked = filteredSources.indexOf(sourceId) > -1 ? 'on' : undefined;
    const handleClick = () => checked ? removeFilteredSource(sourceId) : addFilteredSource(sourceId);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
      key: index,
      checked: checked,
      onClick: handleClick
    }, /*#__PURE__*/_react.default.createElement(_source_option_item.SourceOptionItem, {
      source: contentSources.filter(({
        id
      }) => id === sourceId)[0]
    }));
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "euiFilterSelect__items"
  }, sources);
};
exports.SourcesList = SourcesList;