"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourcesRouter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _app_logic = require("../../app_logic");
var _constants = require("../../constants");
var _routes = require("../../routes");
var _add_source = require("./components/add_source");
var _add_custom_source = require("./components/add_source/add_custom_source");
var _add_external_connector = require("./components/add_source/add_external_connector");
var _add_source_byo_intro = require("./components/add_source/add_source_byo_intro");
var _add_source_choice = require("./components/add_source/add_source_choice");
var _add_source_intro = require("./components/add_source/add_source_intro");
var _organization_sources = require("./organization_sources");
var _private_sources = require("./private_sources");
var _source_router = require("./source_router");
var _sources_logic = require("./sources_logic");
require("./sources.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SourcesRouter = () => {
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const {
    resetSourcesState
  } = (0, _kea.useActions)(_sources_logic.SourcesLogic);
  const {
    account: {
      canCreatePrivateSources
    },
    isOrganization
  } = (0, _kea.useValues)(_app_logic.AppLogic);

  /**
   * React router is not triggering the useEffect callback function in Sources when child links are clicked so this
   * is needed to ensure that the sources state is reset whenever the app changes routes.
   */
  (0, _react.useEffect)(() => {
    resetSourcesState();
  }, [pathname]);

  /**
   * When opening `workplace_search/p/sources/add` as a bookmark or reloading this page,
   * Sources router first get rendered *before* it receives the canCreatePrivateSources value.
   * This results in canCreatePrivateSources always being undefined on the first render,
   * and user always getting redirected to `workplace_search/p/sources`.
   * Here we check for this value being present before we render any routes.
   */
  if (canCreatePrivateSources === undefined) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.PRIVATE_SOURCES_PATH
  }, /*#__PURE__*/_react.default.createElement(_private_sources.PrivateSources, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.SOURCES_PATH
  }, /*#__PURE__*/_react.default.createElement(_organization_sources.OrganizationSources, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: (0, _routes.getAddPath)(_constants.GITHUB_VIA_APP_SERVICE_TYPE)
  }, /*#__PURE__*/_react.default.createElement(_add_source.GitHubViaApp, {
    isGithubEnterpriseServer: false
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: (0, _routes.getAddPath)(_constants.GITHUB_ENTERPRISE_SERVER_VIA_APP_SERVICE_TYPE)
  }, /*#__PURE__*/_react.default.createElement(_add_source.GitHubViaApp, {
    isGithubEnterpriseServer: true
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: `${(0, _routes.getSourcesPath)((0, _routes.getAddPath)('external'), isOrganization)}/intro`,
    "data-test-subj": "ConnectorBYOIntroRoute"
  }, /*#__PURE__*/_react.default.createElement(_add_source_byo_intro.AddSourceBYOIntro, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: `${(0, _routes.getSourcesPath)((0, _routes.getAddPath)(':serviceType'), isOrganization)}/intro`,
    "data-test-subj": "ConnectorIntroRoute"
  }, /*#__PURE__*/_react.default.createElement(_add_source_intro.AddSourceIntro, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: `${(0, _routes.getSourcesPath)((0, _routes.getAddPath)(':serviceType'), isOrganization)}/choice`,
    "data-test-subj": "ConnectorChoiceRoute"
  }, /*#__PURE__*/_react.default.createElement(_add_source_choice.AddSourceChoice, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: `${(0, _routes.getSourcesPath)((0, _routes.getAddPath)('external'), isOrganization)}/connector_registration`,
    "data-test-subj": "ExternalConnectorConfigRoute"
  }, /*#__PURE__*/_react.default.createElement(_add_external_connector.ExternalConnectorConfig, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: `${(0, _routes.getSourcesPath)((0, _routes.getAddPath)('external', ':baseServiceType'), isOrganization)}/connector_registration`,
    "data-test-subj": "ExternalConnectorConfigRoute"
  }, /*#__PURE__*/_react.default.createElement(_add_external_connector.ExternalConnectorConfig, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: `${(0, _routes.getSourcesPath)((0, _routes.getAddPath)('custom'), isOrganization)}/`,
    "data-test-subj": "AddCustomSourceRoute"
  }, /*#__PURE__*/_react.default.createElement(_add_custom_source.AddCustomSource, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: `${(0, _routes.getSourcesPath)((0, _routes.getAddPath)('custom', ':baseServiceType'), isOrganization)}/`,
    "data-test-subj": "AddCustomSourceRoute"
  }, /*#__PURE__*/_react.default.createElement(_add_custom_source.AddCustomSource, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: `${(0, _routes.getSourcesPath)((0, _routes.getAddPath)(':serviceType'), isOrganization)}/:initialStep?`,
    "data-test-subj": "AddSourceRoute"
  }, /*#__PURE__*/_react.default.createElement(_add_source.AddSource, null)), canCreatePrivateSources ? /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: (0, _routes.getSourcesPath)(_routes.ADD_SOURCE_PATH, false)
  }, /*#__PURE__*/_react.default.createElement(_add_source.AddSourceList, null)) : /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    exact: true,
    from: (0, _routes.getSourcesPath)(_routes.ADD_SOURCE_PATH, false),
    to: _routes.PRIVATE_SOURCES_PATH
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: (0, _routes.getSourcesPath)(_routes.ADD_SOURCE_PATH, true)
  }, /*#__PURE__*/_react.default.createElement(_add_source.AddSourceList, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: (0, _routes.getSourcesPath)(_routes.SOURCE_DETAILS_PATH, isOrganization)
  }, /*#__PURE__*/_react.default.createElement(_source_router.SourceRouter, null)));
};
exports.SourcesRouter = SourcesRouter;